function isp( X )
X = X / max(abs(X(:))) * 255; 
[~,~,h] = size(X);

figure
for j = 1:h
    temp_img = X(:,:,j);
    if sum(temp_img(:)) == 0, continue, end
    h = imagesc(temp_img(end:-1:1,:));
    title(num2str(j))
    caxis([0 255])
    colormap('jet')
    axis square
    set(h,'alphadata',~isnan(temp_img));
    set(gca,'xtick',[]), set(gca,'ytick',[])
    pause;
end

end