function [basic_img,final_img] = DDTF3D(amp_factor, noisy_img,noise_level,px,py,pz,sx,sy,sz)

noisy_img = noisy_img * amp_factor;

% basic parameters
[m,n,o] = size(noisy_img);
mpx = m - px + 1; npy = n - py + 1; opz = o - pz + 1;
Px = 1:sx:mpx; if Px(length(Px))~=mpx, Px = [Px,mpx]; end, lx = length(Px);
Py = 1:sy:npy; if Py(length(Py))~=npy, Py = [Py,npy]; end, ly = length(Py);
Pz = 1:sz:opz; if Pz(length(Pz))~=opz, Pz = [Pz,opz]; end, lz = length(Pz);

% DCT dictionary
Dxyz = kron(dctmtx(pz), kron(dctmtx(py) , dctmtx(px)))';

% constructing the patch dataset
Pu = NaN * zeros(px * py * pz, lx * ly * lz);
row = 0;
count_num = zeros(m,n,o);
for j = 0:px-1
    for k = 0:py-1
        for l = 0:pz-1
            row = row + 1;
            temp_noisy = noisy_img(Px+j,Py+k,Pz+l);
            count_num(Px+j,Py+k,Pz+l) = count_num(Px+j,Py+k,Pz+l) + 1;
            Pu(row,:) = temp_noisy(:)';
        end
    end
end

% for num_iter = 1:5
%     % updating the coefficients
%     noisy_coef = Dxy' * Pu;
%     noisy_coef = hard_threshold(noisy_coef, 2.6 * noise_level);
%     % updating the dictionary
%     [U,~,V] = svd(Pu * noisy_coef'); Dxy = U * V';
% end

% frequency hard-thresholding
noisy_coef = Dxyz' * Pu;
basic_coef = hard_threshold(noisy_coef, 2.6 * noise_level);
Pu = Dxyz * basic_coef;

% aggregation
basic_img = zeros(m,n,o);
row = 0;
for j = 0:px-1
    for k = 0:py-1
        for l = 0:pz-1
            row = row + 1;
            basic_img(Px+j,Py+k,Pz+l) = basic_img(Px+j,Py+k,Pz+l) + reshape(Pu(row,:),lx,ly,lz);
        end
    end
end
% post-processing
basic_img = basic_img ./ count_num;
basic_img(basic_img < 0) = 0;

%% Wiener filtering
% constructing the patch dataset
Pu = NaN * zeros(px * py * pz, lx * ly * lz);
row = 0;
count_num = zeros(m,n,o);
for j = 0:px-1
    for k = 0:py-1
        for l = 0:pz-1
            row = row + 1;
            temp_noisy = noisy_img(Px+j,Py+k,Pz+l);
            count_num(Px+j,Py+k,Pz+l) = count_num(Px+j,Py+k,Pz+l) + 1;
            Pu(row,:) = temp_noisy(:)';
        end
    end
end

basic_coef = Dxyz' * Pu;
noisy_coef = basic_coef.^2 ./ (basic_coef.^2 + noise_level.^2) .* noisy_coef; 
Pu = Dxyz * noisy_coef;
% aggregation
final_img = zeros(m,n,o);
row = 0;
for j = 0:px-1
    for k = 0:py-1
        for l = 0:pz-1
            row = row + 1;
            final_img(Px+j,Py+k,Pz+l) = final_img(Px+j,Py+k,Pz+l) + reshape(Pu(row,:),lx,ly,lz);
        end
    end
end
final_img = final_img ./ count_num;
final_img(final_img < 0) = 0;
final_img = final_img / amp_factor;

basic_img = basic_img / amp_factor;
final_img = final_img / amp_factor;
end