function tau = update_tau(PEH, N, lambda, S)
[num_meas, num_bin] = size(PEH);
tau = zeros(num_meas, num_bin);
for n_meas = 1:num_meas
    for n_bin = 1:num_bin
        if isnan(S(n_meas, n_bin)), continue, end
        if PEH(n_meas, n_bin) == 0
            tau(n_meas, n_bin) = PEH_zero_opt(N, lambda, S(n_meas, n_bin));
        else
            tau(n_meas, n_bin) = PEH_nonzero_opt...
                (N - PEH(n_meas, n_bin), PEH(n_meas, n_bin),...
                lambda, S(n_meas, n_bin));
        end
    end
end
end