function mask = determine_mask(noisy_img)
max_value = max(noisy_img(:));
pxo = 3; pyo = 3; pzo = 3;
sparse_value = 25/255 * max_value; 
sparse_threshold = 6;
[m,n,o] = size(noisy_img);      
mask = zeros(n,o);
mpx = m - pxo + 1; npy = n - pyo + 1; opz = o - pzo + 1;
Px = 1:mpx; if Px(length(Px))~=mpx, Px = [Px,mpx]; end, lx = length(Px);
Py = 1:npy; if Py(length(Py))~=npy, Py = [Py,npy]; end, ly = length(Py);
Pz = 1:opz; if Pz(length(Pz))~=opz, Pz = [Pz,opz]; end, lz = length(Pz);
for j = 1:lx
    for k = 1:ly
        for l = 1:lz
            jj = Px(j); kk = Py(k); ll = Pz(l);
            ref_patch = noisy_img(jj:jj+pxo-1,kk:kk+pyo-1,ll:ll+pzo-1);
            ref_patch = ref_patch(:);
            if sum(abs(ref_patch) > sparse_value) >= sparse_threshold
                mask(k+1,l+1) = 1;
            end 
        end
    end
end
mask = extend_boundary(mask);
end

