function iss(sub_Sig, C_i, yg, zg, pause_flag)
[num_meas, num_bin] = size(sub_Sig);
lys = length(yg);
lzs = length(zg);
X = NaN * zeros(lys,lzs,num_bin);
for s = 1:num_meas
    temp_sig = sub_Sig(s,:);
    temp_y_ind = C_i(s,2);
    temp_z_ind = C_i(s,3);
    X(yg == temp_y_ind,zg == temp_z_ind,:) = temp_sig;
end

X = X ./ max(X(:)) * 255;

figure
for bin = 1:num_bin
    temp_img = rot90(X(:,:,bin));
    if max(temp_img(:)) == 0, continue, end 
    h = imagesc(temp_img);
    title(num2str(bin))
    caxis([0 255])
    colormap('jet')
    axis square
    set(h,'alphadata',~isnan(temp_img));
    set(gca,'color',[0 0 0]);
    set(gca,'xtick',[]), set(gca,'ytick',[])
    if pause_flag == 1
        pause;
    else
        pause(0.01)
    end
end
end