function data_2D = weighted_summation(weight_3D, loc, data)
%% Step 1: Weighted summation for 2D object
% Input: Weight_3D
%% Step 2: Denoise_interp_2D
[~,m,n] = size(weight_3D);
data_2D = NaN * zeros(m,n);
%% Weighted summation
for j = 1:m
    for k = 1:n
        if loc(j,k) == 0, continue, end
        temp_data = data(:,j,k);
        temp_weight = weight_3D(:,j,k);
        temp_ind = find(temp_data ~= 0); 
        temp_data = temp_data(temp_ind); 
        temp_weight = temp_weight(temp_ind);
        temp_weight = temp_weight / sum(temp_weight);
        data_2D(j,k) = sum(temp_weight .* temp_data);
    end
end