function [basic_img,final_img,Dxy] = DDTF2D(amp_factor, noisy_img,noise_level,px,py,sx,sy)

noisy_img = noisy_img * amp_factor;

% basic parameters
[m,n] = size(noisy_img);
mpx = m - px + 1; npy = n - py + 1;
Px = 1:sx:mpx; if Px(length(Px))~=mpx, Px = [Px,mpx]; end, lx = length(Px);
Py = 1:sy:npy; if Py(length(Py))~=npy, Py = [Py,npy]; end, ly = length(Py);

% DCT dictionary
Dxy = kron(dctmtx(py) , dctmtx(px))';

% constructing the patch dataset
Pu = NaN * zeros(px * py, lx * ly);
row = 0;
count_num = zeros(m,n);
for j = 0:px-1
    for k = 0:py-1
            row = row + 1;
            temp_noisy = noisy_img(Px+j,Py+k);
            count_num(Px+j,Py+k) = count_num(Px+j,Py+k) + 1;
            Pu(row,:) = temp_noisy(:)';
    end
end

% for num_iter = 1:5
%     % updating the coefficients
%     noisy_coef = Dxy' * Pu;
%     noisy_coef = hard_threshold(noisy_coef, 2.6 * noise_level);
%     % updating the dictionary
%     [U,~,V] = svd(Pu * noisy_coef'); Dxy = U * V';
% end

% frequency hard-thresholding
noisy_coef = Dxy' * Pu;
basic_coef = hard_threshold(noisy_coef, 2.6 * noise_level);
Pu = Dxy * basic_coef;

% aggregation
basic_img = zeros(m,n);
row = 0;
for j = 0:px-1
    for k = 0:py-1
            row = row + 1;
            basic_img(Px+j,Py+k) = basic_img(Px+j,Py+k) + reshape(Pu(row,:),lx,ly);
    end
end
% post-processing
basic_img = basic_img ./ count_num;
basic_img(basic_img < 0) = 0;

%% Wiener filtering
% constructing the patch dataset
Pu = NaN * zeros(px * py, lx * ly);
row = 0;
count_num = zeros(m,n);
for j = 0:px-1
    for k = 0:py-1
            row = row + 1;
            temp_noisy = basic_img(Px+j,Py+k);
            count_num(Px+j,Py+k) = count_num(Px+j,Py+k) + 1;
            Pu(row,:) = temp_noisy(:)';
    end
end
basic_coef = Dxy' * Pu;
noisy_coef = basic_coef.^2 ./ (basic_coef.^2 + noise_level.^2) .* noisy_coef; 
Pu = Dxy * noisy_coef;
% aggregation
final_img = zeros(m,n);
row = 0;
for j = 0:px-1
    for k = 0:py-1
            row = row + 1;
            final_img(Px+j,Py+k) = final_img(Px+j,Py+k) + reshape(Pu(row,:),lx,ly);
    end
end
final_img = final_img ./ count_num;
final_img(final_img < 0) = 0;
final_img = final_img / amp_factor;
end