# Fast Point Cloud Generation with Straight Flows

## About This Code:
This code is mainly for illustrating the procedure of the PSF. Due to the time limit and some policy issues, we do not fully clean and release the code at this time. We will release the full and well-cleaned code once the paper is accepted.

The major usage of this code base is to help reviewers evaluate the algorithm itself.
The main part of the codebase is build upon [PVD](https://github.com/alexzhou907/PVD).
Our main algorithm is implemented at train_flow.py L85-106, train_reflow.py L85-108, train_distill.py L84-107. These three parts correspond to the three stages of the PSF.




## Requirements:

Make sure the following environments are installed.

```
python==3.6
pytorch==1.4.0
torchvision==0.5.0
cudatoolkit==10.1
matplotlib==2.2.5
tqdm==4.32.1
open3d==0.9.0
trimesh=3.7.12
scipy==1.5.1
```

We also need to install pytorch3D for Chamfer Distance Loss, we recommend to follow the offical
install guideline [here](https://github.com/facebookresearch/pytorch3d/blob/main/INSTALL.md)

Install PyTorchEMD by
```
cd metrics/PyTorchEMD
python setup.py install
cp build/**/emd_cuda.cpython-36m-x86_64-linux-gnu.so .
```


## Data

We use the same point cloud as PVD and PointFlow, which can be downloaded [here](https://github.com/stevenygd/PointFlow). Extract and put the data in ./data/ folder


## Training:

First Stage, train the flow model. We do not add EMA here for a simple and quick converge as illustration.
```bash
$ python train_flow.py --category car|chair|airplane
```
Assume the checkpoint is saved as flow_checkpoint.pth (you can find it in the ./output/train_flow/ )

Second Stage, straight the flow, first sample the data pairs. We provide a single GPU version, in practice, we use
multiGPU to speed up, it needs some file operator and we do not clean it up yet.

```bash
$ python train_flow.py --category car|chair|airplane --model flow_checkpoint.pth
```
Then run the reflow procedure:

```bash
$ python train_reflow.py --category car|chair|airplane --model flow_checkpoint.pth
```
Assume the checkpoint is saved as reflow_checkpoint.pth (you can find it in the ./output/train_reflow/ )

Third Stage, distill the flow.
```bash
$ python train_distill.py --category car|chair|airplane --model reflow_checkpoint.pth
```

Assume the checkpoint is saved as distill_checkpoint.pth (you can find it in the ./output/train_distill/ )


## Testing:

```bash
$ python test_flow.py --category car|chair|airplane --model {flow|reflow|distill}_checkpoint.pth --step 1|20|50|100|500|1000
```

You can adjust the step in this testing code. For flow, reflow model, we can still expect a good few-step generation.
