# TINC: Tree-structured Implicit Neural Compression

## Quickstart

### 1. Setup a conda environment and install the pytorch

    conda create -n TINC python=3.9
    conda activate TINC
    conda install pytorch torchvision torchaudio cudatoolkit=11.1 -c pytorch -c nvidia

### 2. Installing python libraries

    pip install -r requirements.txt
### 3. Compression
(1) Single compression task

relevant compression parameters can be modified in **opt/SingleTask/default.yaml**.

    python main.py -p opt/SingleTask/default.yaml -g 0 

final compressed file path: **outputs/default_{time}/compressed/**

final decompressed file path: **outputs/default_{time}/decompressed.tif**

training result: 

    tensorboard --logdir=outputs/default_{time}

(2) Run multiple tasks at once

relevant compression parameters can be modified in **opt/MultiTask/default.yaml**.

    python MultiTask.py -p opt/MultiTask/default.yaml -g 0,1,2,3 -stp main.py -debug