import argparse
from engines.GCNClsTrainer import GCNClsTrainer
from engines.GCNJoTrainer import GCNJoTrainer


def get_args():
    parser = argparse.ArgumentParser(description='Train the Net',
                                     formatter_class=argparse.ArgumentDefaultsHelpFormatter)
    parser.add_argument('--gcls', action='store_true', help='GCNClsTrainer')
    parser.add_argument('--gjo', action='store_true', help='GCNJoTrainer')

    return parser.parse_args()


if __name__ == '__main__':
    opt = get_args()
    if opt.gcls == True:
        trainer = GCNClsTrainer()
    elif opt.gjo == True:
        trainer = GCNJoTrainer()
    else:
        ValueError('Please input the right param.')

    trainer.train()
    del trainer