import os
import h5py
import scipy.io as scio
import numpy as np
import cv2
from numba import jit

def getcolorname(img, size): #size=(w,h)
    mat_path = 'w2c.mat'
    if not os.path.exists(mat_path):
        mat_path = 'utils/w2c.mat'
    data = scio.loadmat(mat_path)
    maps = data['w2c']
    if isinstance(size, int):
        size = (size, size)
    elif isinstance(size, tuple):
        assert len(size) == 2 and isinstance(size[0], int) and isinstance(size[1], int)
    else:
        raise ValueError(f'{size}')
    img_ = cv2.resize(img, size)
    img_ = img_ / 8
    img_ = img_.astype(int)
    idx = img_[:,:,2] + 32*img_[:,:,1] + 32*32*img_[:,:,0]
    output = maps[idx.reshape(-1)].reshape((size[1], size[0], 11))
    return output
