# L-CRP: Concept Relevance Propagation for Semantic Segmentation and Object Detection

This is the code for the CVPR submission to the SAIAD workshop.

# How-To:

1. install requirements (tested with Python 3.8.10)
2. setup dataset and models
   1. datasets: download via public available links and setup paths in corresponding dataset python files in /datasets.
      1. cityscapes: https://www.cityscapes-dataset.com
      2. coco2017: https://cocodataset.org
      3. vocs2012: http://host.robots.ox.ac.uk/pascal/VOC/voc2012/
   2. models: download yolov5, yolov6 and deeplab checkpoints and setup paths in corresponding model python files in /models.
      1. deeplabv3plus (resnet50): https://github.com/VainF/DeepLabV3Plus-Pytorch (model python file is adapted from there)
      2. yolov5m: https://github.com/ultralytics/yolov5 (model python file is adapted from there)
      3. yolov6s: https://github.com/meituan/YOLOv6 (model python file is adapted from there)
      4. unet: link will be provided on https://github.com/maxdreyer/L-CRP.
3. run glocal analysis through /scripts/run_glocal_analysis.sh
4. gather concept attributions for all detections via /scripts/run_global_class_concept.sh
5. explanation_complexity experiments
   1. run /scripts/run_plot_explanation_complexity.sh
6. faithfulness experiments
   1. run /scripts/run_instance_perturbation.sh
   2. run /scripts/run_plot_instance_perturbation.sh
7. concept_context experiments
   1. run /scripts/run_concept_backgroundiness.sh 
   2. run /scripts/run_plot_concept_backgroundiness.sh
8. L-CRP explanations can be run via /experiments/glocal_analysis.py
9. Most relevant reference samples (masked) can be computed via /experiments/get_reference_samples.py
