import json
import time
import tempfile
import os,sys
from web3 import Web3, HTTPProvider
import pandas as pd

blockchain_address = 'blockchain endpoint url'
web3 = Web3(HTTPProvider(blockchain_address))

rights_contract_abi=json.loads() #contract abi
rights_contract=web3.eth.contract(address='0x...', abi=rights_contract_abi)

creator_account='0x...' #creator account

#get the balance of the Creator's account
balance=rights_contract.functions.UsersCreditBalance(creator_account).call()
print(balance)

#withdraw balance
block = web3.eth.get_block('latest')
next_gas_price = block.get('baseFeePerGas') * 1.5
gasprice=int(next_gas_price) 

nonce=web3.eth.getTransactionCount(creator_account)

withdrawBalance=rights_contract.functions.WithdrawAllCredit().buildTransaction({
    "maxFeePerGas": gasprice,
    "maxPriorityFeePerGas":gasprice,
    "chainId":5,
    "from": creator_account,
    "nonce": nonce,
    "value":balance})

signed_transaction = web3.eth.account.sign_transaction(withdrawBalance, private_key='')
transaction_hash=web3.eth.send_raw_transaction(signed_transaction.rawTransaction)
transaction_receipt = web3.eth.wait_for_transaction_receipt(transaction_hash, timeout=600)
print(transaction_receipt)
print("Successfully withdrew balance of", row['Artist_Name'])








