import json
import time
import tempfile
import os,sys
from web3 import Web3, HTTPProvider
import pandas as pd

record_of_owned_rights=pd.read_csv('record_of_owned_rights.csv')

blockchain_address = 'url to blockchain endpoint'
web3 = Web3(HTTPProvider(blockchain_address))

copyrights_contract_abi=json.loads('') # path to local abi file of Copyrights contract, otherwise can be pulled using web3py
nfts_contract_abi = json.loads('') # path to local abi file of NFT contract

user_address="0x..."
user_private_key="..."


def getManifestStore(fname):
  temp=tempfile.mktemp('.json', prefix='tmp', dir='/tmp')
  cmd="c2patool -d %s > %s" % (fname,temp)
  os.system(cmd)
  fp=open(temp,'rt')
  fcnt=fp.read()
  fp.close()
  #cmd='rm -rf %s' % temp
  #os.system(cmd)
  try:
    mstore=json.loads(fcnt)
  except Exception as e:
    print(e)
  return mstore


def getContractAddressTokenID(mstore):
  am=mstore['manifests'][mstore['active_manifest']]
  ast=am['assertion_store']
  asset_ref=ast['c2pa.asset-ref']
  ref=asset_ref['references']
  asset=ref[0]
  a=asset['reference']
  uri=a['uri']
  uri=uri.split('/')
  tokenid=uri[-1]
  x=uri[2].split(':')
  smart_contract_address=x[-1]
  return smart_contract_address, tokenid

nonce=web3.eth.getTransactionCount(user_address)

for index, row in record_of_owned_rights.iterrows():

  #get contract id and token id
  manifest_store=getManifestStore(row['local_path_to_image_asset']) #path to c2pa signed local image

  nft_contract_address, tokenid=getContractAddressTokenID(manifest_store)

  tokenid=int(tokenid,16)

  nfts_contract=web3.eth.contract(address=nft_contract_address, abi=nfts_contract_abi)

  #get the owner of the token
  owner_address=nfts_contract.functions.ownerOf(tokenid).call()

  print("owner_address", owner_address, "token id", tokenid)

  copyrights_contract=web3.eth.contract(address=owner_address, abi=copyrights_contract_abi)

  #get the price of exercising training rights
  price=copyrights_contract.functions.PriceofRightUsage(row['UniqueRightID']).call()
  print(price)

  #pay for training with image from User's account, send more to make sure tx goes through
  block = web3.eth.get_block('latest')
  next_gas_price = block.get('baseFeePerGas') * 1.5
  gasprice=int(next_gas_price) 

  payfortraining=copyrights_contract.functions.exerciseRights(row['UniqueRightID'], 1, price).buildTransaction({
      "maxFeePerGas": gasprice,
      "maxPriorityFeePerGas":gasprice,
      "chainId":5,
      "from": user_address,
      "nonce": nonce})

  signed_transaction = web3.eth.account.sign_transaction(payfortraining, private_key=user_private_key)
  transaction_hash=web3.eth.send_raw_transaction(signed_transaction.rawTransaction)
  transaction_receipt = web3.eth.wait_for_transaction_receipt(transaction_hash, timeout=600)
  print(transaction_receipt)
  print("Successfully paid for exercising right id  ",row['UniqueRightID'], "in contract ", owner_address)

  nonce+=1








