from options.base_option import BaseOptions

class TrainT2MOptions(BaseOptions):
    def initialize(self):
        BaseOptions.initialize(self)
        self.parser.add_argument('--batch_size', type=int, default=64, help='Batch size')
        self.parser.add_argument('--max_epoch', type=int, default=500, help='Deprecated')
        # self.parser.add_argument('--max_iters', type=int, default=150_000, help='Training iterations')

        '''LR scheduler'''
        self.parser.add_argument('--lr', type=float, default=2e-4, help='Layers of GRU')
        self.parser.add_argument('--gamma', type=float, default=0.1, help='Layers of GRU')
        self.parser.add_argument('--milestones', default=[50_000], nargs="+", type=int,
                            help="learning rate schedule (iterations)")
        self.parser.add_argument('--warm_up_iter', default=2000, type=int, help='number of total iterations for warmup')

        '''Condition'''
        self.parser.add_argument('--cond_drop_prob', type=float, default=0.1, help='Dimension of hidden unit in GRU')
        self.parser.add_argument("--seed", default=3407, type=int)

        self.parser.add_argument('--is_continue', action="store_true", help='Training iterations')
        self.parser.add_argument('--gumbel_sample', action="store_true", help='Training iterations')
        self.parser.add_argument('--share_weight', action="store_true", help='Training iterations')
        self.parser.add_argument('--is_v2', action="store_true", help='Training iterations')



        self.parser.add_argument('--log_every', type=int, default=50, help='Frequency of printing training progress')
        # self.parser.add_argument('--save_every_e', type=int, default=100, help='Frequency of printing training progress')
        self.parser.add_argument('--eval_every_e', type=int, default=10, help='Frequency of printing training progress')
        self.parser.add_argument('--save_latest', type=int, default=500, help='Frequency of printing training progress')


        self.is_train = True