## Code Usage
Code is at `L0_sampler.py`. In that code, we have developed a a more comprehensive framework that allows users to easily select different interpolation functions. 

When utilizing our L0-sampler, you can easily integrate it into your project by downloading `L0_sampler.py`, and place it in the same directory where the sampling is performed. And at the beginning of the code, first import it like:

```
    from .L0_sampler import *
```

And then, take NeRF for example, replace
```
  z_samples = sample_pdf(z_vals_mid, weights[...,1:-1], N_importance, det=(perturb==0.), ...)
```
in the source code with
```
  z_samples = L0_sample_pdf(z_vals[..., 1:-1], weights[...,1:-1], N_importance, spline_type={spline_type}, det=(perturb==0.), blur=True, ...)
```
You can adjust the details according to the code.

Just remember to make the intervals and weights has the same size to interpolate properly. When setting `blur=True`, it implies the utilization of Maxblur strategy (see the paper for more details).

The `{spline_type}` can be choosen from: {`'linear'`, `'exp'`, `'inv'`, `'piecepoly'`, `'tpz'`, `'cubic'`, `'akima'`}. Their specific implementation can be found in the code.