

# Blur2Blur: Blur Conversion For Unsupervised Image Deblurring On Unknown Domains

# Overview
`blur2blur` builds upon the CycleGAN method for unpaired image-to-image transfer
and improves its performance by modifying the generator, discriminator, and the
training procedure.

This README file provides brief instructions about how to set up the `blur2blur`
package and reproduce the paper results. To further facilitate the
reproducibility we share the pre-trained models
(c.f. section Pre-trained models)

The code of `blur2blur` is based on [pytorch-CycleGAN-and-pix2pix](https://github.com/junyanz/pytorch-CycleGAN-and-pix2pix)
and [uvcgan2](https://github.com/LS4GAN/uvcgan2).


# Installation & Requirements

## Requirements

`blur2blur` models were trained under the official `pytorch` container
`pytorch/pytorch:1.12.1-cuda11.3-cudnn8-runtime`. A similar training
environment can be constructed with `conda`
```
conda env create -f contrib/conda_env.yaml
```

## Installation

To install the `blur2blur` package one can simply run the following command
```
python3 setup.py develop --user
```
from the `b2b` source tree.

## Environment Setup

`blur2blur` extensively uses two environment variables `BLUR2BLUR_DATA` and
`BLUR2BLUR_OUTDIR` to locate user data and output directories. Users are advised
to set these environment variables. `blur2blur` will look for datasets in the
`${BLUR2BLUR_DATA}` directory and will save results under the `${BLUR2BLUR_OUTDIR}`
directory. If these variables are not set then they will default to `./data`
and `./outdir` correspondingly.

## Pre-trained models

We provide pre-trained generators that were used to obtain the final results.
They can be found on [GoogleDrive](https://drive.google.com/drive/folders/1yCzem3V29rSlw9dIJlhmqN5IGgL8IUZy?usp=sharing).


## Download Datasets

We download the dataset and unzip in `BLUR2BLUR_DATA`

# Training and Inference



## Training

Our Blur2Blur main script is `scripts/train_b2b_base.py`

This script can be simply run like
```bash
python3 scripts/train_b2b_base.py --name b2b --model b2b_base --no-pretrain
```

More details can be found by looking over the scripts. Each of them contains
a training configuration, which should be self-explanatory.

When the training is finished, the pre-trained generators will be saved under
the "${BLUR2BLUR_OUTDIR}" directory.

## Testing (or Inference)
```bash
python3 scripts/translate_images.py b2b \
                                    --split test --epoch -1 \
                                    --prefix images \
```


