from run import EMOE_run
import argparse

def parse_arguments():
    parser = argparse.ArgumentParser(description="Run EMOE model with specified parameters.")
    parser.add_argument('--model_name', type=str, default='emoe', help='Name of the model')
    parser.add_argument('--dataset_name', type=str, help='Name of the dataset')
    parser.add_argument('--is_tune', type=bool, help='Whether to tune the model')
    parser.add_argument('--seeds', type=int, nargs='+', default=[1111], help='List of seeds for random initialization')
    parser.add_argument('--model_save_dir', type=str, default='./pt', help='Directory to save the model')
    parser.add_argument('--res_save_dir', type=str, default='./result', help='Directory to save the results')
    parser.add_argument('--log_dir', type=str, default='./log', help='Directory to save the logs')
    parser.add_argument('--mode', type=str, help='Mode of operation)')
    
    args = parser.parse_args()
    return args


if __name__ == "__main__":
    args = parse_arguments()

    EMOE_run(model_name=args.model_name,    
             dataset_name=args.dataset_name,
             is_tune=args.is_tune,
             seeds=args.seeds,
             model_save_dir=args.model_save_dir,
             res_save_dir=args.res_save_dir,
             log_dir=args.log_dir,
             mode=args.mode)
