#!/bin/bash
#SBATCH --nodes=1
#SBATCH --ntasks-per-node=2
#SBATCH --gpus-per-task=1

<<com
Example Slurm evaluation script. 
Notes:
- VQAv2 test-dev and test-std annotations are not publicly available. 
  To evaluate on these splits, please follow the VQAv2 instructions and submit to EvalAI.
  This script will evaluate on the val split.
com

export PYTHONFAULTHANDLER=1
export CUDA_LAUNCH_BLOCKING=0
# export HOSTNAMES=hostname -I | awk '{print $1}'
export MASTER_ADDR=172.17.0.2
export MASTER_PORT=29968
# export COUNT_NODE=`scontrol show hostnames "$SLURM_JOB_NODELIST" | wc -l`

# echo go $COUNT_NODE
# echo $HOSTNAMES

export PYTHONPATH="$PYTHONPATH:open_flamingo"
torchrun --nnodes=1 --nproc_per_node=8  open_flamingo/eval/evaluate.py \
    --vision_encoder_path ViT-L-14 \
    --vision_encoder_pretrained openai\
    --lm_path /data/jcy/ckpt/anas-awadalla/mpt-1b-redpajama-200b-dolly \
    --lm_tokenizer_path /data/jcy/ckpt/anas-awadalla/mpt-1b-redpajama-200b-dolly \
    --cross_attn_every_n_layers 1 \
    --checkpoint_path "/data/jcy/open_flamingo/OpenFlamingo-3B-DPO-symbol-vqav2-improve-10k-noinstruct/checkpoint_final.pt" \
    --results_file "results_noinstruct_final_vqav2_improve_10k.json" \
    --precision amp_bf16 \
    --batch_size 32 \
    --eval_vqav2 \
    --coco_train_image_dir_path "/data/jcy/data/data/coco/train2014" \
    --coco_val_image_dir_path "/data/jcy/data/data/coco/val2014" \
    --coco_karpathy_json_path "/data/jcy/data/data/karpathy/dataset_coco.json" \
    --coco_annotations_json_path "/data/jcy/data/data/coco/annotations/captions_val2014.json" \
    --vqav2_train_image_dir_path "/data/jcy/data/data/VQAv2/train2014" \
    --vqav2_train_annotations_json_path "/data/jcy/data/data/VQAv2/v2_mscoco_train2014_annotations.json" \
    --vqav2_train_questions_json_path "/data/jcy/data/data/VQAv2/v2_OpenEnded_mscoco_train2014_questions.json" \
    --vqav2_test_image_dir_path "/data/jcy/data/data/VQAv2/val2014" \
    --vqav2_test_annotations_json_path "/data/jcy/data/data/VQAv2/v2_mscoco_val2014_annotations.json" \
    --vqav2_test_questions_json_path "/data/jcy/data/data/VQAv2/v2_OpenEnded_mscoco_val2014_questions.json" \
    --flickr_image_dir_path "/data/jcy/data/data/Flickr_30K/flickr30k-images" \
    --flickr_karpathy_json_path "/data/jcy/data/data/karpathy/dataset_flickr30k.json" \
    --flickr_annotations_json_path "/data/jcy/data/data/Flickr_30K/dataset_flickr30k_coco_style.json" \
    --ok_vqa_train_image_dir_path "/data/jcy/data/data/coco/train2014" \
    --ok_vqa_train_annotations_json_path "/data/jcy/data/data/OKVQA/mscoco_train2014_annotations.json" \
    --ok_vqa_train_questions_json_path "/data/jcy/data/data/OKVQA/OpenEnded_mscoco_train2014_questions.json" \
    --ok_vqa_test_image_dir_path "/data/jcy/data/data/coco/val2014" \
    --ok_vqa_test_annotations_json_path "/data/jcy/data/data/OKVQA/mscoco_val2014_annotations.json" \
    --ok_vqa_test_questions_json_path "/data/jcy/data/data/OKVQA/OpenEnded_mscoco_val2014_questions.json" \
    --textvqa_image_dir_path "/data/jcy/data/data/textvqa/train_images/" \
    --textvqa_train_questions_json_path "/data/jcy/data/data/textvqa/train_questions_vqa_format.json" \
    --textvqa_train_annotations_json_path "/data/jcy/data/data/textvqa/train_annotations_vqa_format.json" \
    --textvqa_test_questions_json_path "/data/jcy/data/data/textvqa/val_questions_vqa_format.json" \
    --textvqa_test_annotations_json_path "/data/jcy/data/data/textvqa/val_annotations_vqa_format.json" \
    --vizwiz_train_image_dir_path "/data/jcy/data/data/Vizwiz/train" \
    --vizwiz_test_image_dir_path "/data/jcy/data/data/Vizwiz/val" \
    --vizwiz_train_questions_json_path "/data/jcy/data/data/Vizwiz/train_questions_vqa_format.json" \
    --vizwiz_train_annotations_json_path "/data/jcy/data/data/Vizwiz/train_annotations_vqa_format.json" \
    --vizwiz_test_questions_json_path "/data/jcy/data/data/Vizwiz/val_questions_vqa_format.json" \
    --vizwiz_test_annotations_json_path "/data/jcy/data/data/Vizwiz/val_annotations_vqa_format.json" \
    --hateful_memes_image_dir_path "/data/jcy/data/data/hatefulmemes/data/img" \
    --hateful_memes_train_annotations_json_path "/data/jcy/data/data/hatefulmemes/data/train.jsonl" \
    --hateful_memes_test_annotations_json_path "/data/jcy/data/data/hatefulmemes/data/dev.jsonl" 
# torchrun --nnodes=1 --nproc_per_node=8 --master_port=29600 open_flamingo/eval/evaluate.py \
#     --vision_encoder_path ViT-L-14 \
#     --vision_encoder_pretrained openai\
#     --lm_path /data/jcy/ckpt/anas-awadalla/mpt-1b-redpajama-200b-dolly \
#     --lm_tokenizer_path /data/jcy/ckpt/anas-awadalla/mpt-1b-redpajama-200b-dolly \
#     --cross_attn_every_n_layers 1 \
#     --checkpoint_path "/data/jcy/open_flamingo/OpenFlamingo-3B-dpo-symbol/checkpoint_1250.pt" \
#     --results_file "results_of_new_1250.json" \
#     --precision amp_bf16 \
#     --batch_size 16 \
#     --eval_vqav2 \
#     --vqav2_train_image_dir_path "/data/jcy/data/data/VQAv2/train2014" \
#     --vqav2_train_annotations_json_path "/data/jcy/data/data/VQAv2/v2_mscoco_train2014_annotations.json" \
#     --vqav2_train_questions_json_path "/data/jcy/data/data/VQAv2/v2_OpenEnded_mscoco_train2014_questions.json" \
#     --vqav2_test_image_dir_path "/data/jcy/data/data/VQAv2/val2014" \
#     --vqav2_test_annotations_json_path "/data/jcy/data/data/VQAv2/v2_mscoco_val2014_annotations.json" \
#     --vqav2_test_questions_json_path "/data/jcy/data/data/VQAv2/v2_OpenEnded_mscoco_val2014_questions.json" 

# torchrun --nnodes=1 --nproc_per_node=8 --master_port=29600 open_flamingo/eval/evaluate.py \
#     --vision_encoder_path ViT-L-14 \
#     --vision_encoder_pretrained openai\
#     --lm_path /data/jcy/ckpt/anas-awadalla/mpt-1b-redpajama-200b-dolly \
#     --lm_tokenizer_path /data/jcy/ckpt/anas-awadalla/mpt-1b-redpajama-200b-dolly \
#     --cross_attn_every_n_layers 1 \
#     --checkpoint_path "/data/jcy/open_flamingo/OpenFlamingo-3B-dpo-symbol/checkpoint_2500.pt" \
#     --results_file "results_of_new_2500.json" \
#     --precision amp_bf16 \
#     --batch_size 64 \
#     --eval_vqav2 \
#     --vqav2_train_image_dir_path "/data/jcy/data/data/VQAv2/train2014" \
#     --vqav2_train_annotations_json_path "/data/jcy/data/data/VQAv2/v2_mscoco_train2014_annotations.json" \
#     --vqav2_train_questions_json_path "/data/jcy/data/data/VQAv2/v2_OpenEnded_mscoco_train2014_questions.json" \
#     --vqav2_test_image_dir_path "/data/jcy/data/data/VQAv2/val2014" \
#     --vqav2_test_annotations_json_path "/data/jcy/data/data/VQAv2/v2_mscoco_val2014_annotations.json" \
#     --vqav2_test_questions_json_path "/data/jcy/data/data/VQAv2/v2_OpenEnded_mscoco_val2014_questions.json" 

# torchrun --nnodes=1 --nproc_per_node=8 --master_port=29600 open_flamingo/eval/evaluate.py \
#     --vision_encoder_path ViT-L-14 \
#     --vision_encoder_pretrained openai\
#     --lm_path /data/jcy/ckpt/anas-awadalla/mpt-1b-redpajama-200b-dolly \
#     --lm_tokenizer_path /data/jcy/ckpt/anas-awadalla/mpt-1b-redpajama-200b-dolly \
#     --cross_attn_every_n_layers 1 \
#     --checkpoint_path "/data/jcy/open_flamingo/OpenFlamingo-3B-dpo-symbol/checkpoint_final.pt" \
#     --results_file "results_of_new_3750.json" \
#     --precision amp_bf16 \
#     --batch_size 16 \
#     --eval_vqav2 \
#     --vqav2_train_image_dir_path "/data/jcy/data/data/VQAv2/train2014" \
#     --vqav2_train_annotations_json_path "/data/jcy/data/data/VQAv2/v2_mscoco_train2014_annotations.json" \
#     --vqav2_train_questions_json_path "/data/jcy/data/data/VQAv2/v2_OpenEnded_mscoco_train2014_questions.json" \
#     --vqav2_test_image_dir_path "/data/jcy/data/data/VQAv2/val2014" \
#     --vqav2_test_annotations_json_path "/data/jcy/data/data/VQAv2/v2_mscoco_val2014_annotations.json" \
#     --vqav2_test_questions_json_path "/data/jcy/data/data/VQAv2/v2_OpenEnded_mscoco_val2014_questions.json" 
    # --vision_encoder_path ViT-L-14 \
    # --vision_encoder_pretrained openai\
    # --lm_path anas-awadalla/mpt-1b-redpajama-200b \
    # --lm_tokenizer_path anas-awadalla/mpt-1b-redpajama-200b \
    # --cross_attn_every_n_layers 1 \
    # --checkpoint_path "openflamingo/OpenFlamingo-3B-vitl-mpt1b/checkpoint.pt" \
    # --results_file "results.json" \
    # --precision amp_bf16 \
    # --batch_size 8 \
    # --eval_coco \
    # --eval_vqav2 \
    # --eval_flickr30 \
    # --eval_ok_vqa \
    # --eval_textvqa \
    # --eval_vizwiz \
    # --eval_hateful_memes \
    # --coco_train_image_dir_path "/path/to/mscoco_karpathy/train2014" \
    # --coco_val_image_dir_path "/path/to/mscoco_karpathy/val2014" \
    # --coco_karpathy_json_path "/path/to/mscoco_karpathy/dataset_coco.json" \
    # --coco_annotations_json_path "/path/to/mscoco_karpathy/annotations/captions_val2014.json" \
    # --vqav2_train_image_dir_path "/path/to/vqav2/train2014" \
    # --vqav2_train_annotations_json_path "/path/to/vqav2/v2_mscoco_train2014_annotations.json" \
    # --vqav2_train_questions_json_path "/path/to/vqav2/v2_OpenEnded_mscoco_train2014_questions.json" \
    # --vqav2_test_image_dir_path "/path/to/vqav2/val2014" \
    # --vqav2_test_annotations_json_path "/path/to/vqav2/v2_mscoco_val2014_annotations.json" \
    # --vqav2_test_questions_json_path "/path/to/vqav2/v2_OpenEnded_mscoco_val2014_questions.json" \
    # --flickr_image_dir_path "/data/jcy/data/data/Flickr_30K/flickr30k-images" \
    # --flickr_karpathy_json_path "/data/jcy/data/data/karpathy/dataset_flickr30k.json" \
    # --flickr_annotations_json_path "/path/to/flickr30k/dataset_flickr30k_coco_style.json" \
    # --ok_vqa_train_image_dir_path "/path/to/okvqa/train2014" \
    # --ok_vqa_train_annotations_json_path "/path/to/okvqa/mscoco_train2014_annotations.json" \
    # --ok_vqa_train_questions_json_path "/path/to/okvqa/OpenEnded_mscoco_train2014_questions.json" \
    # --ok_vqa_test_image_dir_path "/path/to/okvqa/val2014" \
    # --ok_vqa_test_annotations_json_path "/path/to/okvqa/mscoco_val2014_annotations.json" \
    # --ok_vqa_test_questions_json_path "/path/to/okvqa/OpenEnded_mscoco_val2014_questions.json" \
    # --textvqa_image_dir_path "/path/to/textvqa/train_images/" \
    # --textvqa_train_questions_json_path "/path/to/textvqa/train_questions_vqa_format.json" \
    # --textvqa_train_annotations_json_path "/path/to/textvqa/train_annotations_vqa_format.json" \
    # --textvqa_test_questions_json_path "/path/to/textvqa/val_questions_vqa_format.json" \
    # --textvqa_test_annotations_json_path "/path/to/textvqa/val_annotations_vqa_format.json" \
    # --vizwiz_train_image_dir_path "/path/to/v7w/train" \
    # --vizwiz_test_image_dir_path "/path/to/v7w/val" \
    # --vizwiz_train_questions_json_path "/data/jcy/data/data/Vizwiz/train_questions_vqa_format.json" \
    # --vizwiz_train_annotations_json_path "/data/jcy/data/data/Vizwiz/train_annotations_vqa_format.json" \
    # --vizwiz_test_questions_json_path "/data/jcy/data/data/Vizwiz/val_questions_vqa_format.json" \
    # --vizwiz_test_annotations_json_path "/data/jcy/data/data/Vizwiz/val_annotations_vqa_format.json" \
    # --hateful_memes_image_dir_path "/path/to/hateful_memes/img" \
    # --hateful_memes_train_annotations_json_path "/path/to/hateful_memes/train.json" \
    # --hateful_memes_test_annotations_json_path "/data/jcy/data/data/hatefulmemes/train.jsonl" \