import os
from pathlib import Path
from omegaconf import OmegaConf

def generate_test_cases(image_dir, pose_root_dir):
    test_cases = {}
    image_files = sorted(Path(image_dir).glob('*.jpg'))
    
    for image_path in image_files:
        image_name = image_path.stem
        pose_dir = Path(pose_root_dir) / image_name
        if not pose_dir.exists():
            continue
        
        pose_videos = []
        for model_dir in pose_dir.iterdir():
            if model_dir.is_dir():
                for sample_dir in model_dir.iterdir():
                    if sample_dir.is_dir() and sample_dir.name.startswith("samples_4.0"):
                        for text_dir in sample_dir.iterdir():
                            if text_dir.is_dir():
                                video_dir = text_dir / 'videos'
                                if video_dir.exists():
                                    num_pose = 0
                                    for video_file in sorted(video_dir.glob('*.mp4')):
                                        
                                        if 'detail' in os.path.basename(video_file):
                                            pose_videos.append(os.path.abspath(str(video_file)))
                                            num_pose += 1
                                            if num_pose >= 3:
                                                break
        
        if pose_videos:
            test_cases[os.path.abspath(str(image_path))] = pose_videos
    
    return test_cases

# 设置输入输出路径
image_dir = '/root/users/kkk/home/kkk/DECA/TestSamples/celebv_text'
pose_root_dir = '/root/users/kkk/home/kkk/DECA/results/MDMevaluate'

# 生成 test_cases
test_cases = generate_test_cases(image_dir, pose_root_dir)

# 保存到yaml文件
output_config = {
    'test_cases': test_cases
}

config_path = '/root/users/jusjus/AniPortrait/configs/prompts/animation_flame_full.yaml'
OmegaConf.save(config=output_config, f=config_path)
