import cv2
import os
import yaml
import os

def create_video_from_images(folder_path, output_path, fps):
    for root, dirs, files in os.walk(folder_path):
        for file in files:
            image_files = []
            if file.endswith(".jpg") or file.endswith(".png"):
                image_files.append(os.path.join(root, file))
                first_image = cv2.imread(image_files[0])
                height, width, _ = first_image.shape

                # Create a video writer object
                fourcc = cv2.VideoWriter_fourcc(*"mp4v")
                output_path1 = f"{output_path}/{file}.mp4"
                print(output_path1)
                video_writer = cv2.VideoWriter(output_path1, fourcc, fps, (width, height))

                # Write each image to the video
                for image_file in image_files:
                    for i in range(10):
                        image = cv2.imread(image_file)
                        video_writer.write(image)

                # Release the video writer
                video_writer.release()

                print("Video created successfully.")
            else:
                continue


# Example usage
base_path = "/root/users/jusjus/AniPortrait"
for folder in os.listdir(f"{base_path}/teaser/results"):
    folder_path = f"{base_path}/teaser/results/{folder}"
    print(folder_path)
    output_path = f"{base_path}/teaser/results/{folder}"
    fps = 30

    create_video_from_images(folder_path, output_path, fps)


def represent_dict_order(dumper, data):
    return dumper.represent_mapping('tag:yaml.org,2002:map', data.items())

def write_config_yaml(config_path, config_data):
    yaml.add_representer(dict, represent_dict_order)

    with open(config_path, 'w') as file:
        yaml.dump(config_data, file, default_flow_style=False)

# Test case
def gen_yaml(img, vid):
    config_data = {
        'pretrained_base_model_path': '/mnt/znzz/kkk/models/runwayml/stable-diffusion-v1-5',
        'pretrained_vae_path': '/mnt/znzz/kkk/models/stabilityai/sd-vae-ft-mse',
        'image_encoder_path': '/mnt/znzz/kkk/models/lambdalabs/sd-image-variations-diffusers',
        'denoising_unet_path': "/mnt/znzz/jus/AniPortrait/celebv_single_detailed_output/stage1/denoising_unet-137000.pth",
        'reference_unet_path': "/mnt/znzz/jus/AniPortrait/celebv_single_detailed_output/stage1/reference_unet-137000.pth",
        'pose_guider_path': "/mnt/znzz/jus/AniPortrait/celebv_single_detailed_output/stage1/pose_guider-137000.pth",
        'motion_module_path': "/mnt/znzz/jus/AniPortrait/celebv_single_detailed_output/stage2/motion_module-16434.pth",
        'inference_config': "./configs/inference/inference_v2.yaml",
        'weight_dtype': 'fp16'
    }

    config_data["test_cases"] = {f"{img}": [f"{vid}"]}
    config_data["save_dir"] = "/root/users/jusjus/AniPortrait/teaser/results_single_detailed"
    write_config_yaml("/root/users/jusjus/AniPortrait/configs/prompts/config_renderme_detailed.yaml", config_data)

def gen_yaml_single_smooth(img, vid):
    config_data = {
        'pretrained_base_model_path': '/mnt/znzz/kkk/models/runwayml/stable-diffusion-v1-5',
        'pretrained_vae_path': '/mnt/znzz/kkk/models/stabilityai/sd-vae-ft-mse',
        'image_encoder_path': '/mnt/znzz/kkk/models/lambdalabs/sd-image-variations-diffusers',
        'denoising_unet_path': "/mnt/znzz/jus/AniPortrait/celebv_single_smooth_output/stage1/denoising_unet-299650.pth",
        'reference_unet_path': "/mnt/znzz/jus/AniPortrait/celebv_single_smooth_output/stage1/reference_unet-299650.pth",
        'pose_guider_path': "/mnt/znzz/jus/AniPortrait/celebv_single_smooth_output/stage1/pose_guider-299650.pth",
        'motion_module_path': "/mnt/znzz/jus/AniPortrait/celebv_single_smooth_output/stage2/motion_module-3992.pth",
        'inference_config': "./configs/inference/inference_v2.yaml",
        'weight_dtype': 'fp16'
    }

    config_data["test_cases"] = {f"{img}": [f"{vid}"]}
    config_data["save_dir"] = "/root/users/jusjus/AniPortrait/teaser/results_single_smooth"
    write_config_yaml("/root/users/jusjus/AniPortrait/configs/prompts/config_renderme_detailed.yaml", config_data)

def gen_yaml_renderme(img, vid):
    config_data = {
        "pretrained_base_model_path": '/mnt/znzz/kkk/models/runwayml/stable-diffusion-v1-5',
        "pretrained_vae_path": '/mnt/znzz/kkk/models/stabilityai/sd-vae-ft-mse',
        "image_encoder_path": '/mnt/znzz/kkk/models/lambdalabs/sd-image-variations-diffusers',
        "denoising_unet_path": "/mnt/znzz/jus/AniPortrait/renderme_multiview_output_v10_resume/stage1/denoising_unet-138847.pth",
        "reference_unet_path": "/mnt/znzz/jus/AniPortrait/renderme_multiview_output_v10_resume/stage1/reference_unet-138847.pth",
        "pose_guider_path"   : "/mnt/znzz/jus/AniPortrait/renderme_multiview_output_v10_resume/stage1/pose_guider-138847.pth",
        "motion_module_path": "/mnt/znzz/jus/AniPortrait/celebv_single_detailed_output/stage2/motion_module-30961.pth",
        "inference_config": "./configs/inference/inference_v2.yaml",
        "weight_dtype": 'fp16'
    }

    config_data["test_cases"] = {f"{img}": [f"{vid}"]}
    config_data["save_dir"] = "/root/users/jusjus/AniPortrait/teaser/results_multiview_detailed"
    write_config_yaml("/root/users/jusjus/AniPortrait/configs/prompts/config_renderme_detailed.yaml", config_data)


for folder in os.listdir(f"{base_path}/teaser/results"):
    source = f"{base_path}/teaser"
    folder_path = f"{base_path}/teaser/results/{folder}"
    for file in list(set([i.split(".")[0] for i in os.listdir(folder_path)])):
        img_name= file.split("_yaw")[0]

        gen_yaml(f"{source}/{img_name}.jpg", f"{folder_path}/{file}.png.mp4")
        os.system("python -m scripts.pose2vid --config ./configs/prompts/config_renderme_detailed.yaml -W 512 -H 512 -acc")

        gen_yaml_renderme(f"{source}/{img_name}.jpg", f"{folder_path}/{file}.png.mp4")
        os.system("python -m scripts.pose2vid --config ./configs/prompts/config_renderme_detailed.yaml -W 512 -H 512 -acc")
        
        gen_yaml_single_smooth(f"{source}/{img_name}.jpg", f"{folder_path}/{file}.png.mp4")
        os.system("python -m scripts.pose2vid --config ./configs/prompts/config_renderme_detailed.yaml -W 512 -H 512 -acc")