
import cv2
import os

def extract_frames(video_path, save_path, ty):
    # Create a directory to save the frames if it doesn't exist
    if not os.path.exists(save_path):
        os.makedirs(save_path)

    # Open the video file
    cap = cv2.VideoCapture(video_path)
    
    frame_count = 0

    while(cap.isOpened()):
        ret, frame = cap.read()

        if not ret:
            break

        imgname = video_path.split(f"{ty}/")[-1].split("512x512_3_")[1].split(".png")[0]
        frame_path = os.path.join(save_path, f"{imgname}.jpg")
        cv2.imwrite(frame_path, frame)
        
        frame_count += 1

    cap.release()
    cv2.destroyAllWindows()


save_path = "/root/users/jusjus/AniPortrait/teaser/results_multiview_detailed_img"

single_detailed = "/root/users/jusjus/AniPortrait/teaser/results_single_detailed"
multiview_detailed = "/root/users/jusjus/AniPortrait/teaser/results_multiview_detailed"
single_smooth = "/root/users/jusjus/AniPortrait/teaser/results_single_smooth"
multiview_detailed_v11 = "/root/users/jusjus/AniPortrait/teaser/results_multiview_detailed_v11"

single_detailed_save_path = "/root/users/jusjus/AniPortrait/teaser/results_single_detailed_img"
multiview_detailed_save_path = "/root/users/jusjus/AniPortrait/teaser/results_multiview_detailed_img"
single_smooth_save_path = "/root/users/jusjus/AniPortrait/teaser/results_single_smooth_img"
multiview_detailed_save_path_v11 = "/root/users/jusjus/AniPortrait/teaser/results_multiview_detailed_v11_img"

# Call the function to extract frames
for i in os.listdir(single_detailed):
    print(i)
    extract_frames(f"{single_detailed}/{i}", single_detailed_save_path, "results_single_detailed")

for i in os.listdir(multiview_detailed):
    print(i)
    extract_frames(f"{single_detailed}/{i}", multiview_detailed_save_path, "results_multiview_detailed")

for i in os.listdir(single_smooth):
    print(i)
    extract_frames(f"{single_smooth}/{i}", single_smooth_save_path, "results_single_smooth")

for i in os.listdir(multiview_detailed_v11):
    print(i)
    extract_frames(f"{multiview_detailed_v11}/{i}", multiview_detailed_save_path_v11, "multiview_detailed_v11")