
# Code

## TOC
- [Experiment Preparation](#experiment-preparation)
- [Experiment Code for LDM](#experiment-code-for-LDM)

## Experiment Preparation

* ### Requirement
Create and activate a suitable conda environment named `cachequant` by using the following command:

```bash
cd CacheQuant
conda env create -f environment.yaml
conda activate cachequant
```

* ### Pretrained Model
Pre-trained models for DDPM are automatically downloaded by the code. For LDM and Stable Diffusion experiments, download relevant pre-trained models to *mainldm/models/ldm* following the instructions in the [latent-diffusion](https://github.com/CompVis/latent-diffusion#model-zoo) and [stable-diffusion](https://github.com/CompVis/stable-diffusion#weights) repos. 

* ### Data
Please download all original datasets used for evaluation from each dataset’s official website. We provide prompts for Stable Diffusion in *mainldm/prompt*. 



## Experiment Code for LDM

* ### Introduction
The repo provides code for all experiments. We use the LDM-4 on ImageNet as an example to illustrate the usage. Other experiments are implemented similarly.

* ### Usage

1. Obtain DPS and Calibration
```bash
python ./mainldm/sample_cachequant_imagenet_cali.py
```
2. Get Cached Features
```bash
python ./mainldm/sample_cachequant_imagenet_predadd.py
```
3. Get Quantized Parameters
```bash
python ./mainldm/sample_cachequant_imagenet_params.py
```
4. Calculate DEC for Cache and Quant
```bash
python ./err_add/imagenet/cache_draw.py
```
5. Sample
```bash
python ./mainldm/sample_cachequant_imagenet_quant.py <--recon>
```
The `--recon` to use reconstruction.




