#!/bin/bash

{
source ~/.bashrc
conda activate SLfM
cd /home/anmin/code/SLfM/slfm

CUDAs=(1 2 3 4 5 6 7)
CUDA='1,2,3,4'
BATCH_SIZE=120
CLIP_LENGTH=0.63
LOSS_TYPE='ve011'
N_SS_POSITION_CLF=6
# WEIGHTS='--weights=HM3D/wsSL/bl/bl_supervised-CondLength=2.55'

CUDA='3'

#60 for 0.63,6;36 for 0.63,10
BATCH_SIZE=36
# WEIGHTS='--weights=HM3D/wsSL/unet-based/LbS-r0.2-2ssp-Length2.55-rg-rtf-v002111-lre-4/pretext_best.pth.tar'
# EXP="HM3D/wsSL/yb-cars/LbS-r0.2-2ssp-Length${CLIP_LENGTH}-rg-rtf-${LOSS_TYPE}-rough_n${N_SS_POSITION_CLF}-lre-4-pretrained"

WEIGHTS=''
EXP="HM3D/wsSL/bl/bl_supervised-Length=2.55-n32-rtf-lr10e-4"
WEIGHTS="--weights=$EXP/net_best.pth.tar"

AZIMUTH_LOSS_TYPE='--azimuth_loss_type=regression'
RESTRAIN_TO_FRONT='--restrain_to_front'
DATASET_MOD='0'
N_SS_POSITION=2
INPUT='ws'

EXP="HM3D/wsSL/avnerf-ws/v00213-rtf--rg-rough_n1-LibriSpeech-r0.2-2ssp-Length1.27-lre-4"
WEIGHTS="--weights=$EXP/ws_best.pth.tar"

AZIMUTH_LOSS_TYPE='--azimuth_loss_type=regression'
RESTRAIN_TO_FRONT='--restrain_to_front'
DATASET_MOD='7'
N_SS_POSITION=2
INPUT='ws'

SHARED_FLAG='--setting=wssl_hm3d --repeat=1 --data-setting hm3d-wsSL-r0.2 
 --epochs=1000 --vision_backbone=resnet18 --audio_backbone=resnet18 
 --num_workers=45 --save_step=3 --valid_step=1 --lr=0.0001 --optim=AdamW  
 --schedule=cos --unet_input_nc=2 --unet_output_nc=2 --n_source=1 --cond_clip_length=5.10 
 --no_cond_audio --no_vision --eval --n_source=1 --audiobase_path=data/AI-Habitat/data-split/LibriSpeech 
 --n_view=1 --online_render --color_jitter --imagenet_pretrain '

mkdir -p ./results/${EXP}

CUDA_VISIBLE_DEVICES=$CUDA python evaluation/evaluate_angle.py ${WEIGHTS} ${SHARED_FLAG} \
--clip_length ${CLIP_LENGTH} --n_ss_position_clf ${N_SS_POSITION_CLF} \
--exp=${EXP} \
--loss_type=${LOSS_TYPE} --n_ss_position=${N_SS_POSITION} \
${AZIMUTH_LOSS_TYPE} --batch_size=${BATCH_SIZE} ${RESTRAIN_TO_FRONT} --dataset_mod ${DATASET_MOD} --input ${INPUT}

# CUDA_VISIBLE_DEVICES=$CUDA python evaluation/evaluate_angle.py --exp=$EXP --setting=$setting --vision_backbone=$vision_backbone --audio_backbone=$audio_backbone --batch_size=$batch_size --num_workers=$num_workers --n_source=$N_source --n_view=$N_view --online_render  --add_geometric --activation=$activation --audiobase_path=$audiobase_path $shared_flag --input='vision' --weights="${EXP}/vision_best.pth.tar" > "./results/${EXP}/vision_res.txt"


}