#!/bin/bash
{
source ~/.bashrc
conda activate ss


cudas=(0 0 0 0 0 1 1 1 1 1 2 2 2 2 2 3 3 3 3 3 4 4 4 4 4)
max=25

dataset='hm3d'


------ Rotation ------ #
num_scene=2500
num_source=1
num_camera=500
num_angle=40
num_view=4
outdir='/datab/anmin/tmp/hm3d-movingSL-d4.0-n10-tmp1'
flag='--audio-with-trajectory --high-resol --distance 4.0 --rir-to-sound'


for (( i=0; i < $max; i++))
do {
    echo "Process \"$i\" started";
    CUDA_VISIBLE_DEVICES=${cudas[$i]} nice -n 0 python generate_moving_audio.py --dataset=$dataset --output-dir=$outdir --num-per-scene=$num_scene --num-source=$num_source --num-camera=$num_camera --num-view=$num_view --num-angle=$num_angle $flag --split=$i --total=$max & pid=$! 
} done

trap "kill $PID_LIST" SIGINT

echo "Parallel processes have started";

wait $PID_LIST

echo
echo "All processes have completed";

}