def divide_line_segment(point1, point2, n):
    if n < 2:
        raise ValueError("n must be at least 2")

    x1, y1, z1 = point1
    x2, y2, z2 = point2

    # 初始化一个空列表来存储均匀分布的点坐标
    points = []

    for i in range(n):
        # 计算每个点的坐标
        alpha = i / (n - 1)  # 在[0, 1]范围内均匀分布的参数
        x = x1 + alpha * (x2 - x1)
        y = y1 + alpha * (y2 - y1)
        z = z1 + alpha * (z2 - z1)
        points.append((x, y, z))

    return points