#!/bin/bash

{
source ~/.bashrc
conda activate SLfM
cd /home/anmin/code/SLfM/slfm


# -------------------------- Training: wssl -------------------------- #
echo "Start training wssl task...";

CUDA=5

WEIGHTS=''
LOSS_TYPE='v002131' # v002131
N_SS_POSITION_CLF=36
RESTRAIN_TO_FRONT='--restrain_to_front';RTF='rtf'
BATCH_SIZE=36
AZIMUTH_LOSS_TYPE='--azimuth_loss_type=classification';RG='clf'
# AZIMUTH_LOSS_TYPE='--azimuth_loss_type=regression';RG='rg'

# -------------------------- Dataset -------------------------- #
DATASET_MOD='0'
CLIP_LENGTH=2.55
DATA_SETTING='hm3d-wsSL-r0.2';DS=''
DATA_SETTING='hm3d-wsSL-r0.2-40degree';DS='rt40'
N_SS_POSITION=2
WEIGHTS=''
WITH_PRETRAIN=''


CLIP_LENGTH=0.63
# WEIGHTS='--weights=HM3D/wsSL/simu-ws/v002131-rtf--clf-rough_n36-LbS-r0.2-2ssp-Length2.55-lre-4/ws_best.pth.tar'
DATASET_MOD='1'
DATA_SETTING='Youtube-binaural-cars_scenes_v00';DS='uni'
N_SS_POSITION=4
DATASET_FOLDER='yb-cars'

WITH_PRETRAIN='pretrained-ws-'


CLIP_LENGTH=0.63
# WEIGHTS='--weights=HM3D/wsSL/simu-ws/vc01-rtf--clf-rough_n1-LbS-r0.2-2ssp-Length0.63-lre-4/ws_best.pth.tar'
DATASET_MOD='2'
DATA_SETTING='Youtube-IntheWild';DS=''
N_SS_POSITION=1
DATASET_FOLDER='yb-inwild'

WITH_PRETRAIN='pretrained-ws-'



if [ "$WEIGHTS" != '' ] && [ "$WITH_PRETRAIN" == '' ]; then
    WITH_PRETRAIN='pretrained-ws-'
fi



if [ "$RESTRAIN_TO_FRONT" != '' ]; then
    RTF='rtf'
fi

if [ "$CLIP_LENGTH" == 0.63 ]; then
    BATCH_SIZE=100
fi


if [ "$DATASET_MOD" == '0' ]; then
    DATASET_FOLDER='simu'
fi

FOLDER="$DATASET_FOLDER-ws"
if [ "$LOSS_TYPE" == 've01' ]; then
    FOLDER="$DATASET_FOLDER-bl"
fi



# -------------------------- Training: wssl -------------------------- #

EXP="HM3D/wsSL/${FOLDER}/${WITH_PRETRAIN}${LOSS_TYPE}-${RTF}-${DS}-${RG}-rough_n${N_SS_POSITION_CLF}-LbS-r0.2-${N_SS_POSITION}ssp-Length${CLIP_LENGTH}-lre-4"
SHARED_FLAG='--setting=wssl_hm3d --epochs=1000 --vision_backbone=resnet18 --audio_backbone=resnet18 
--num_workers=45 --save_step=3 --valid_step=1 --lr=0.0001 --optim=AdamW 
--repeat=1 --schedule=cos --unet_input_nc=2 --unet_output_nc=2 --n_source=1 --cond_clip_length=5.10 --no_cond_audio --no_vision 
--eval --n_source=1 
--audiobase_path=data/AI-Habitat/data-split/LibriSpeech  
--n_view=1 --online_render --color_jitter --imagenet_pretrain '

INPUT='ws'
WEIGHTS="--weights=$EXP/ws_best.pth.tar"

mkdir -p ./results/${EXP}

CUDA_VISIBLE_DEVICES=${CUDA} python evaluation/evaluate_angle.py ${WEIGHTS} ${SHARED_FLAG} \
--clip_length ${CLIP_LENGTH} --n_ss_position_clf ${N_SS_POSITION_CLF} \
--exp=${EXP} --data-setting ${DATA_SETTING} \
--loss_type=${LOSS_TYPE} --n_ss_position=${N_SS_POSITION} \
${AZIMUTH_LOSS_TYPE} --batch_size=${BATCH_SIZE} ${RESTRAIN_TO_FRONT} --dataset_mod ${DATASET_MOD} --input ${INPUT}


}