# Supplementary Material: Reanimating Images using Neural Representations of Dynamic Stimuli

This zip file includes a supplemental PDF with additional results and provides reanimation examples.

## Overview

The project contains the following:

1. **Supplemental.pdf**: A supplemental document with additional information about the dataset, encoding model controls and baselines, and voxel-wise encoding performance for each visual encoding model shown on inflated cortical maps.

2. **index.html**: An HTML file that displays reanimation examples. For each example, we show the ground truth video, the reanimated video using the flow predicted from the ground truth initial frame, and the reanimated video using the flow predicted from the initial frame generated by MindVideo [1].

3. **Decoding_Models_Visualizations/**: A directory containing examples. Each example has its own directory, e.g., `Jellyfish/` which contains: `ground_truth.gif`, `ground_truth_initial_frame_and_ours.gif`, and `mindvideo_initial_frame_and_ours.gif`.

## Viewing the reanimation examples

1. Open the `index.html` file in any web browser.
2. Each row corresponds to a subject (e.g., Deer, Jellyfish).
3. Columns in the HTML table display:
   - **Ground Truth** GIF
   - **Ground Truth + Ours** GIF
   - **MindVideo + Ours** GIF

---

**Reference:**

1. Chen, Z., Qing, J., & Zhou, J. H. (2023). *Cinematic Mindscapes: High-Quality Video Reconstruction from Brain Activity*. In Proceedings of the Thirty-Seventh Conference on Neural Information Processing Systems (NeurIPS 2023).
