## Usage
This repository provides the code to train and evaluate MoLA on text-motion datasets, HumanML3D.



## Examples
Example 1. Traning Stage 1(VAE+SAN) on HumanML3D:
```
$ python train_vaesan.py --batch-size 128 --latent-dim 16 --out-dir output --encoder-input root_pos_rot --vae-act leakyrelu --kl-weight 1e-4 --gan-weight 1e-3 --exp-name mola_stage1
```


Example 2. Training Stage 2(Conditional motion latent diffusion) on HumanML3D:
```
$ python train_diffusion.py --batch-size 64 --out-dir output --resume-vae output/mola_stage1/net_best_fid.pth --latent-dim 16 --clip-dim 512 --encoder-input root_pos_rot --cfg-guidance-scale 11 --exp-name mola_stage2
```


## Evaluation
Example 3. Stage 1(VAE+SAN) on HumanML3D:
```
$ python eval_stage1_vaesan.py --batch-size 32 --out-dir output --vae-act leakyrelu --encoder-input root_pos_rot --resume-vae output/mola_stage1/net_best_fid.pth --exp-name test_mola_stage1
```


Example 4. Stage 2 on HumanML3D:
```
$ python eval_stage2_diffusion.py --batch-size 32 --latent-dim 16 --resume-vae output/mola_stage1/net_best_fid.pth --resume-dit output/mola_stage2/net_best_fid.pth --vae-name VAESAN --out-dir output --encoder-input root_pos_rot --vae-act leakyrelu --inference-timestep 50 --cfg-guidance-scale 11 --exp-name test_mola_stage2
```

Example 5. Motion editing on HumanML3D
```
$ python eval_stage2_diffusion.py --batch-size 32 --latent-dim 16 --resume-vae output/mola_stage1/net_best_fid.pth --resume-dit output/mola_stage2/net_best_fid.pth --vae-name VAESAN --out-dir output --encoder-input root_pos_rot --vae-act leakyrelu --inference-timestep 50 --cfg-guidance-scale 11 --exp-name test_mola_stage2 --edit-mode path
```



## List of corresponding sections and execution examples
| Section | Example | Description |
| ---- | ---- | ---- |
| Section 4.1, 4.3 | Example 1, 2, 3, 4 | Training and evaluating stage1-2 model (motion generation task) |
| Section 4.2, 4.3 | Example 5 | Evaluating stage2 model on path-following (motion editing task) |