import torch
import torch.nn as nn

from transformers import CLIPVisionModel, CLIPImageProcessor, VisionEncoderDecoderModel,DonutProcessor


class DonutEncoder(nn.Module):
    def __init__(self, chart_tower, args, delay_load=False):
        super().__init__()

        self.is_loaded = False

        self.chart_tower_name = chart_tower
        self.select_layer = args.mm_chart_select_layer
        # self.select_feature = getattr(args, 'mm_vision_select_feature', 'patch')


        self.load_model()

    def load_model(self):
        
        self.chart_processor = DonutProcessor.from_pretrained(self.chart_tower_name)
        model = VisionEncoderDecoderModel.from_pretrained(self.chart_tower_name)
        self.chart_tower = model.get_encoder()
        self.chart_tower.requires_grad_(False)
        
        self.is_loaded = True
            
        # self.image_processor = CLIPImageProcessor.from_pretrained(self.vision_tower_name)
        # self.vision_tower = CLIPVisionModel.from_pretrained(self.vision_tower_name)
        # self.vision_tower.requires_grad_(False)

        # self.is_loaded = True

    def feature_select(self, chart_forward_outs):
        chart_features = chart_forward_outs.hidden_states[self.select_layer]
        chart_features = chart_features[:, 1:]
        # if self.select_feature == 'patch':
        #     image_features = image_features[:, 1:]
        # elif self.select_feature == 'cls_patch':
        #     image_features = image_features
        # else:
        #     raise ValueError(f'Unexpected select feature: {self.select_feature}')
        return chart_features

    @torch.no_grad()
    def forward(self, charts):
        # if type(images) is list:
        #     image_features = []
        #     for image in images:
        #         image_forward_out = self.vision_tower(image.to(device=self.device, dtype=self.dtype).unsqueeze(0), output_hidden_states=True)
        #         image_feature = self.feature_select(image_forward_out).to(image.dtype)
        #         image_features.append(image_feature)
        # else:
        #     image_forward_outs = self.vision_tower(images.to(device=self.device, dtype=self.dtype), output_hidden_states=True)
        #     image_features = self.feature_select(image_forward_outs).to(images.dtype)
        chart_forward_outs = self.chart_tower(charts.to(device=self.device, dtype=self.dtype), output_hidden_states=True)
        chart_features = self.feature_select(chart_forward_outs).to(charts.dtype)

        return chart_features

    @property
    def dummy_feature(self):
        return torch.zeros(1, self.hidden_size, device=self.device, dtype=self.dtype)

    @property
    def dtype(self):
        return self.chart_tower.dtype

    @property
    def device(self):
        return self.chart_tower.device

    @property
    def config(self):
        if self.is_loaded:
            return self.chart_tower.config
        else:
            raise NotImplementedError
            return self.cfg_only

    @property
    def hidden_size(self):
        return self.config.hidden_size

    @property
    def num_patches(self):
        raise NotImplementedError
        # return (self.config.image_size // self.config.patch_size) ** 2
