## MCBT Dataset

### Overview
The **MCBT Dataset (Manufacturing Complex Background Texture)** is designed for training and evaluating **AL-CycleGAN** on **defect detection in manufacturing samples**. It contains **anomaly (defective)** and **defect-free** image samples across training and testing sets.

### File Structure
The dataset is structured as follows:
```
MCBT_dataset/
│── ground_truths/    # Contains ground truth labels or annotations
│── trainA/           # Anomaly (defective) samples for training
│── trainB/           # Defect-free samples for training
│── testA/            # Anomaly (defective) samples for testing
│── testB/            # Defect-free samples for testing
```

### Usage
To use this dataset for training and testing **AL-CycleGAN**, follow these steps:

1. **Download and Place Data**  
   Ensure that `MCBT_dataset` is located in the appropriate directory, such as:
   ```
   ./datasets/MCBT_dataset/
   ```

2. **Train the Model**
   ```bash
   python train.py --dataroot ./datasets/MCBT_dataset --name al-cyclegan_exp --model cycle_gan
   ```

3. **Test the Model**
   ```bash
   python test.py --dataroot ./datasets/MCBT_dataset --name al-cyclegan_exp --model cycle_gan
   ```

4. **View Results**  
   The test results will be stored in:
   ```
   ./results/al-cyclegan_exp/latest_test/index.html
   ```

### Ground Truths
The `ground_truths/` directory contains annotations corresponding to the samples in `trainA`, `trainB`, `testA`, and `testB`. These annotations can be used for evaluation and performance benchmarking.

---

# AL-CycleGAN in PyTorch

**Note**: The AL-CycleGAN code is based on the original implementation by [Jun-Yan Zhu](https://github.com/junyanz) and [Taesung Park](https://github.com/taesungp), modified to incorporate the loss function modification discussed in AL-CycleGAN.

**Note**: The current software works well with PyTorch 1.4.

## Prerequisites
- Linux or macOS
- Python 3
- CPU or NVIDIA GPU + CUDA CuDNN

## Getting Started
- Install [PyTorch](http://pytorch.org) 0.4+ and other dependencies (e.g., torchvision, [visdom](https://github.com/facebookresearch/visdom), and [dominate](https://github.com/Knio/dominate)).
  - For pip users, please type the command `pip install -r requirements.txt`.
  - For Conda users, you can create a new Conda environment using `conda env create -f environment.yml`.
  - For Docker users, we provide the pre-built Docker image and Dockerfile. Please refer to our [Docker](docs/docker.md) page.

### CycleGAN train/test
- Download a CycleGAN dataset (e.g., maps):
```bash
bash ./datasets/download_cyclegan_dataset.sh maps
```
- To view training results and loss plots, run `python -m visdom.server` and click the URL http://localhost:8097.
- To log training progress and test images to the W&B dashboard, set the `--use_wandb` flag with the train and test script.
- Train a model:
```bash
python train.py --dataroot ./MCBT_dataset --name v1 --model cycle_gan
```
To see more intermediate results, check out `./checkpoints/maps_cyclegan/web/index.html`.
- Test the model:
```bash
python test.py --dataroot ./MCBT_dataset --name v1 --model cycle_gan
```
- The test results will be saved to an HTML file here: `./results/maps_cyclegan/latest_test/index.html`.

### Apply a Pre-Trained Model (CycleGAN)
Checkpoints for the models and results mentioned in the paper are available in the Final Model Checkpoints folder.
Make sure you download the final model checkpoints from the following link and place them in the `final_model_checkpoints/` folder:

- Create the checkpoints folder first
```bash
mkdir final_model_checkpoints
```
[Download Final Model Checkpoints](https://drive.google.com/drive/folders/1EV7OYygSis9RAF3CKiZUnTWH4lVC8Run?usp=share_link)  
(*This is an anonymous account and link, and no personal information is linked to this storage.*)

- Then generate the results by inputting relevant dataset and experiment name arguments as shown below:
```bash
python test.py --dataroot ./MCBT_dataset --name al-cyclegan_exp --model cycle_gan --epoch {if needed}
```

## Acknowledgments
Our code is inspired by [pytorch-DCGAN](https://github.com/pytorch/examples/tree/master/dcgan) and [pytorch-CycleGAN-and-pix2pix](https://github.com/junyanz/pytorch-CycleGAN-and-pix2pix). Special thanks to the research team and industry collaborators for contributing data.

