import sys
PATH=""

from datasets.vg import vg
from datasets.loader import region_loader
from utils.config import get_train_config
from utils.vocab import Vocabulary

def stat(loaddbs):
    objs = []
    obj_inds = []
    obj2count = {}
    for loaddb in loaddbs:
        for scene in loaddb:
            obj, obj_ind = scene[5], scene[6]
            objs.append(obj)
            obj_inds.append(obj_ind)
            for o in obj:
                if o in obj2count:
                    obj2count[o] += 1
                else:
                    obj2count[o] = 1
    obj2count = sorted(obj2count.keys(), key= lambda kv: obj2count[kv])
    return objs, obj_inds, obj2count

def main():
    config, unparsed = get_train_config()
    loaddbs = []
    for split in ['train', 'test']:
        db = vg(config, split)
        loaddb = region_loader(db)
        loaddbs.append(loaddb)
    objs, obj_inds, obj2count = stat(loaddbs)
    print('objs: ', objs)
    print('obj_inds: ', obj_inds)
    print('obj2count: ', obj2count)
    top_objs = obj2count[-500:]
    for i in range(len(objs)):
        count = 0
        for o in objs[i]:
            if o in top_objs:
                count += 1
        if count == 0:
            print(i)
    file_path = PATH
    with open(file_path, 'w') as f:
        for obj in top_objs:
            f.write(obj + '\n')
if __name__ == '__main__':
    main()



