function [flowVectorsCoords]=getFlowLocations(flowSize, principalPoint, spatialStep)
    % getFlowLocations
    %   flowSize          - Size of the flow, (X, Y)
    %   principalPoint    - Coordinates of the principal Point (X, Y)
    %   spatialStep       - Number of pixels to skip while sampling the flow (double)
    % RETURNS
    %   flowVectorsCoords - Coords of the flow vectors, Struct with fields X: [HxW double], Y: [HxW double]
    arguments
        flowSize (1, 2) double
        principalPoint (1, 2) double
        spatialStep double
    end

    [Y X] = ndgrid(0:spatialStep:flowSize(2)-1, 0:spatialStep:flowSize(1)-1);

    flowVectorsCoords.Y = Y - principalPoint(2) + 0.5;
    flowVectorsCoords.X = X - principalPoint(1) + 0.5;

end