function [Omega] = estRotation(flow, precomputedLines, binSize, maxAngle, f)
% estRotation
%   flow                - Structure with fields X, Y, Dx, and Dy (see flowConvertor).
%   precomputedLines    - Precomputed lines [H x W x N_POINTS_PER_LINE x 3 double]
%   binSize             - Size of the bins in rad
%   maxAngle            - Range of rotation to search for in rad. The rotation will be searched within [-maxAngle, maxAngle]
%   f                   - Focal length in pixels
%
% RETURN
%   Rotation Vel        - Return the rotation velcity [OmegaX, OmegaY, OmegaZ]

%n_bins_per_dim = max_angle_after_shift .* 2 ./ step + 1;
n_bins_per_dim = maxAngle .* 2 ./ binSize;

n_points_per_line = size(precomputedLines, 3);

% Compute the intersections of the lines of compatible rotations with the plane z=0.
eu_0 = (flow.X.* flow.Y)./f;
eu_1 = -((flow.X.^2)./f+f);

ev_0 = (flow.Y.^2)./ f + f;
ev_1 = -(flow.X.* flow.Y)./ f;

x_0 = (ev_1.* flow.Dx - eu_1.* flow.Dy)./ (eu_0.* ev_1 - eu_1.* ev_0);
y_0 = (ev_0.* flow.Dx - eu_0.* flow.Dy)./ (eu_1.* ev_0 - eu_0.* ev_1);

point = cat(3, x_0, y_0, zeros(size(x_0))); % H, W, 3

point = reshape(point, size(point, 1), size(point, 2), 1, size(point, 3));
point = repmat(point, 1, 1, n_points_per_line, 1);

% Shift all the points given intercept
lines_c = precomputedLines + point;

% Flatten the spatial dimensions
lines_c = reshape(lines_c, [], 3); % (h*w*n_rot, 3)

% Convert rads to bin idx
lines_c = round((lines_c + maxAngle)./ binSize);

% Filter out of bound indices
c = ((lines_c > 0) & (lines_c <= n_bins_per_dim));
row_c = all(c, 2);
lines_c = lines_c(row_c, :);

% Compute the mode
indxs = sub2ind([n_bins_per_dim n_bins_per_dim n_bins_per_dim], lines_c(:,1), lines_c(:,2), lines_c(:,3));
mode_ = mode(indxs);
[i_x, i_y, i_z] = ind2sub([n_bins_per_dim n_bins_per_dim n_bins_per_dim], [mode_]);
indexes = [i_x  i_y i_z];

% Idx to rad
%Omega = indexes.* step + (center - max_angle_after_shift) + step./2;
Omega = indexes.* binSize - maxAngle;
