function n=FNE1(A,P1,P2,u1,v1,u2,v2,ptsCorr,affCorr)

p1=[u1;v1];
p2=[u2;v2];


if (ptsCorr==1)
	F=ComputeFundamentalFromProjections(P1,P2);
	[p1,p2]=HartleySturmTriangulation(F,[u1;v1],[u2;v2]);
	pt3D=LinearTriangulation(P1,p1(1),p1(2),P2,p2(1),p2(2));
else
	pt3D=LinearTriangulation(P1,u1,v1,P2,u2,v2);
end

if (affCorr==1)
    [A]=GetClosestConsistentAffineTransform(A, F, p1(1:2), p2(1:2));
end



	gradU1=CalculateGradientsForU(P1,p1(1),pt3D(1),pt3D(2),pt3D(3));
	gradV1=CalculateGradientsForV(P1,p1(2),pt3D(1),pt3D(2),pt3D(3));

	gradU2=CalculateGradientsForU(P2,p2(1),pt3D(1),pt3D(2),pt3D(3));
	gradV2=CalculateGradientsForV(P2,p2(2),pt3D(1),pt3D(2),pt3D(3));


	p=A(2,2)*cross(gradV1,gradU2)-A(1,1)*cross(gradV2,gradU1); %a4*w1-a1*w4
	q=A(2,1)*cross(gradU2,gradU1)-A(1,2)*cross(gradV1,gradV2); %a3*w2-a2*w3
	v=cross(p,q);

	n=v/norm(v);

end
