%Spec:
%0: nothing special (general camera)
%1: general camera with zero skew
%2: camera with common vertical and horizontal focal length
%3: camera with common vertical and horizontal focal length plus zero principal point
%4: eigenmatrix (for normalized cameras)


function C=GenerateIntrinsics(spec)
  
  if (spec==0)
    C=500.0+1000*rand(3,3);
    C(1,2)=10*randn();
    C(2,1)=0;
    C(3,1)=0;
    C(3,2)=0;
    C(3,3)=1.0;
  elseif (spec==1)
    C=500.0+1000*rand(3,3);
    C(1,2)=0.0;
    C(2,1)=0;
    C(3,1)=0;
    C(3,2)=0;
    C(3,3)=1.0;
  elseif (spec==2)
    C=500.0+1000*rand(3,3);
    C(2,2)=C(1,1);
    C(1,2)=0.0;
    C(2,1)=0;
    C(3,1)=0;
    C(3,2)=0;
    C(3,3)=1.0;
  elseif (spec==3)
    C=500.0+1000*rand(3,3);
    C(2,2)=C(1,1);
    C(1,2)=0.0;
    C(2,1)=0;
    C(3,1)=0;
    C(3,2)=0;
    C(3,3)=1.0;
    C(1,3)=0;
    C(2,3)=0;
  elseif (spec==4)
    C=eye(3);
  end
    


end
