%Object:
%1: sphere
%2: general plane
%3: vertical plane: n=[cos(alpha) 0 sin(alpha)]
%4: very special plane: n=[1 0 0]
%5: very special plane: n=[0 1 0]
%6: very special plane: n=[0 0 1]


%PTSNUM: number of generated point for plane fitting

function [pts3D,normals]=GenerateSurface(object,PTSNUM)
  
  pts3D=[];
  normals=[];

  
  if (object==1) %Generate Sphere 
    

    rad=1.0;

    for u=0.5:0.5:pi
      for v=0.5:0.5:(2*pi)
        x=rad*sin(v)*cos(u);
        y=rad*cos(v)*cos(u);
        z=rad*sin(u);
        pts3D(size(pts3D,1)+1,:)=[x,y,z];
        n=[x,y,z];
        n=n/norm(n);
        normals(size(normals,1)+1,:)=n;
      end %for v
    end % for u

    elseif (object==2)

        
        n=randn(3,1);
        n=n/norm(n);
        dirs=null(n');
        v1=dirs(:,1);
        v2=dirs(:,2);
        fixPt=[10*randn;10*randn;10+5*randn];
        for cnt=1:PTSNUM
            scale1=rand;
            scale2=rand;
            pt=fixPt+scale1*v1+scale2*v2;
            pts3D(cnt,1:3)=pt';
            normals(cnt,1:3)=n';
        end %for
        

    elseif (object==3)
        angle=rand*2*pi;
        
        n=[cos(angle);0;sin(angle)]
        dirs=null(n');
        v1=dirs(:,1);
        v2=dirs(:,2);
        fixPt=[10*randn;10*randn;10+5*randn];
        for cnt=1:PTSNUM
            scale1=rand;
            scale2=rand;
            pt=fixPt+scale1*v1+scale2*v2;
            pts3D(cnt,1:3)=pt';
            normals(cnt,1:3)=n';
        end %for
        

    elseif (object==4)

        n=[1;0;0];
        v1=[0;1;0];
        v2=[0;0;1];
        fixPt=[10*randn;10*randn;10+5*randn];
        for cnt=1:PTSNUM
            scale1=rand;
            scale2=rand;
            pt=fixPt+scale1*v1+scale2*v2;
            pts3D(cnt,1:3)=pt';
            normals(cnt,1:3)=n';
        end %for
        
        
    elseif (object==5)

        n=[0;1;0];
        v1=[1;0;0];
        v2=[0;0;1];
        fixPt=[10*randn;10*randn;10+5*randn];
        for cnt=1:PTSNUM
            scale1=rand;
            scale2=rand;
            pt=fixPt+scale1*v1+scale2*v2;
            pts3D(cnt,1:3)=pt';
            normals(cnt,1:3)=n';
        end %for
        
        
    elseif (object==6)
        
        n=[0;0;1];
        v1=[1;0;0];
        v2=[0;1;0];
        fixPt=[10*randn;10*randn;10+5*randn];
        for cnt=1:PTSNUM
            scale1=rand;
            scale2=rand;
            pt=fixPt+scale1*v1+scale2*v2;
            pts3D(cnt,1:3)=pt';
            normals(cnt,1:3)=n';
        end %for
        
     end %if


  
end
