%H*pts1= -> pts2
function H=GetHomography(pts1,pts2)
	NUM1=rows(pts1);
	NUM2=rows(pts2);

	if (NUM1!=NUM2)
		"Error in GetHomography: different sizes of point sets"
		exit;
	endif

	MTX=[];
	for i=1:NUM1
		MTX(2*i-1,:)=[pts1(i,1),pts1(i,2),1.0,0,0,0,-pts1(i,1)*pts2(i,1),-pts1(i,2)*pts2(i,1),-pts2(i,1)];
		MTX(2*i,:)=[0,0,0,pts1(i,1),pts1(i,2),1.0,-pts1(i,1)*pts2(i,2),-pts1(i,2)*pts2(i,2),-pts2(i,2)];
	endfor

	[tmp1,tmp2,V]=svd(MTX);
	homVec=V(:,9);

	H(1,1)=homVec(1);
	H(1,2)=homVec(2);
	H(1,3)=homVec(3);

	H(2,1)=homVec(4);
	H(2,2)=homVec(5);
	H(2,3)=homVec(6);

	H(3,1)=homVec(7);
	H(3,2)=homVec(8);
	H(3,3)=homVec(9);
	
endfunction
