function [u2,v2]=HartleySturmTriangulation(F,u1,v1)

	T1=[1,0,-u1(1);0,1,-u1(2);0,0,1];

	T2=[1,0,-v1(1);0,1,-v1(2);0,0,1];

	F2=inv(T2')*F*inv(T1);

    [tmpU,tmpS,tmpV]=svd(F2);

%	e1=null(F2)
%	e2=null(F2')
    
	e1=tmpV(:,3);
	e2=tmpU(:,3);
    

	s1=e1(1)^2+e1(2)^2;
	s2=e2(1)^2+e2(2)^2;

	e1/s1;
	e2/s1;


	R1=[e1(1),e1(2),0;-e1(2),e1(1),0;0,0,1];
	R2=[-e2(1),-e2(2),0;e2(2),-e2(1),0;0,0,1];

	F3=R2*F2*R1';



	f1=e1(3);

	f2=e2(3);


	a=F3(2,2);
	b=F3(2,3);
	c=F3(3,2);
	d=F3(3,3);



	%Create polinomial:
	t6=-a*c*(f1^4)*(a*d-b*c);
	t5=(a*a+f2*f2*c*c)^2-(a*d+b*c)*(f1^4)*(a*d-b*c);
	t4=2*(a*a+f2*f2*c*c)*(2*a*b+2*c*d*f2*f2)-d*b*(f1^4)*(a*d-b*c)-2*a*c*f1*f1*(a*d-b*c);
	t3=(2*a*b+2*c*d*f2*f2)^2+2*(a*a+f2*f2*c*c)*(b*b+f2*f2*d*d)-2*f1*f1*(a*d-b*c)*(a*d+b*c);
	t2=2*(2*a*b+2*c*d*f2*f2)*(b*b+f2*f2*d*d)-2*(f1*f1*a*d-f1*f1*b*c)*b*d-a*c*(a*d-b*c);
	t1=(b*b+f2*f2*d*d)^2-(a*d+b*c)*(a*d-b*c);
	t0=-(a*d-b*c)*b*d;

	r=[t6,t5,t4,t3,t2,t1,t0];

	bestS=inf;
	rs=roots(r);

	for i=1:rows(rs)
		currRoot=rs(i);
		if (isreal(currRoot))
			val=calculateS(currRoot,a,b,c,d,f1,f2);
			if (val<bestS)
				bestS=val;
				bestT=currRoot;
			end
		end
	end



%	bestS
	valInf=1/(f1^2)+(c^2)/(a^2+f2^2*c^2);
	if (valInf<bestS)
		"Serious error"
		exit;
	end

	point1=[0;bestT;1];
	line2=F3*point1;
	point2=[-line2(1)*line2(3);-line2(2)*line2(3);line2(1)^2+line2(2)^2];
	point2/=point2(3);

	u2=inv(R1*T1)*point1;
	v2=inv(R2*T2)*point2;
	
end
%
%
%F=load("F.mat");
%p1=load("cam.mat");
%p2=load("proj.mat");

%[u2,v2]=HartleySturmTriangulation(F,p1,p2)
%p1
%p2
%exit

