function [nOpt]=OPT(A,P1,P2,u1,v1,u2,v2,ptsCorr,affCorr,mode)

p1=[u1;v1];
p2=[u2;v2];


if (ptsCorr==1)
	F=ComputeFundamentalFromProjections(P1,P2);
	[p1,p2]=HartleySturmTriangulation(F,[u1;v1],[u2;v2]);
	pt3D=LinearTriangulation(P1,p1(1),p1(2),P2,p2(1),p2(2));
else
	pt3D=LinearTriangulation(P1,u1,v1,P2,u2,v2);
end

if (affCorr==1)
    [A]=GetClosestConsistentAffineTransform(A, F, p1(1:2), p2(1:2));
end


	gradU1=CalculateGradientsForU(P1,p1(1),pt3D(1),pt3D(2),pt3D(3));
	gradV1=CalculateGradientsForV(P1,p1(2),pt3D(1),pt3D(2),pt3D(3));

	gradU2=CalculateGradientsForU(P2,p2(1),pt3D(1),pt3D(2),pt3D(3));
	gradV2=CalculateGradientsForV(P2,p2(2),pt3D(1),pt3D(2),pt3D(3));


	p1=cross(gradV1,gradU2);
	p2=cross(gradU2,gradU1);
	p3=cross(gradV1,gradV2);
	p4=cross(gradV2,gradU1);
	p5=cross(gradV1,gradU1);


	a1=A(1,1);
	a2=A(1,2);
	a3=A(2,1);
	a4=A(2,2);

	AS=[a1,a2,a3,a4];

	P=[p1';p2';p3';p4';p5'];  %!!!!!  ????

   if(mode==2)
     ptmp=P(:,2);
     P(:,2)=P(:,3);
     P(:,3)=ptmp;
   elseif (mode==3)
     ptmp=P(:,1);
     P(:,1)=P(:,3);
     P(:,3)=ptmp;
   end




	nOpt=CoreOptimizator(P,AS,1.0);
    
   if(mode==2)
    nOpt=[nOpt(1);nOpt(3);nOpt(2)];
   elseif (mode==3)
    nOpt=[nOpt(3);nOpt(2);nOpt(1)];
   end


end
