function [errsEstFNE,errsEstFNESuper,errsOPT,errsCubic,errsRapid,errsHomography]=TestSystem(PTS_NOISE,AFF_NOISE,REPEATNUM)

    errsEstFNE=[];
    errsEstFNESuper=[];
    errsOPT=[];
    errsCubic=[];
    errsRapid=[];
    errsHomography=[];


    for rep=1:REPEATNUM

        [pts3D,normals,first2D,second2D,As,P1,P2,EGT,C1,R1,t1,C2,R2,t2,R,t]=TestDataGenerator(1,1,PTS_NOISE,AFF_NOISE);



        NUM=size(pts3D,1);



%For debug:
%min, max, spread

%        off1=mean(first2D);
%        off2=mean(second2D);

%        first2DTmp=first2D-ones(NUM,1)*off1;
%        first2DTmp=first2DTmp.*first2DTmp;

%        first2DTmp=mean(first2DTmp);
%        [sqrt(first2DTmp(1)),        sqrt(first2DTmp(2))]

%        second2DTmp=first2D-ones(NUM,1)*off2;
%        second2DTmp=second2DTmp.*second2DTmp;

%        second2DTmp=mean(second2DTmp);
%        [sqrt(second2DTmp(1)),        sqrt(second2DTmp(2))]


%        pause


        for index=1:NUM

            A=As(2*index-1:2*index,:);

            u1=first2D(index,1);
            v1=first2D(index,2);

            u2=second2D(index,1);
            v2=second2D(index,2);

            nGT=normals(index,:)';


            nEst1=FNE1(A,P1,P2,u1,v1,u2,v2,0,0);
            nEst1=nEst1/sign(nEst1(3));

            nEstSuper=FNESuper(A,P1,P2,u1,v1,u2,v2,0,0);
            nEstSuper=nEstSuper/sign(nEstSuper(3));

            nEstOPT=OPT(A,P1,P2,u1,v1,u2,v2,0,0,1);
            nEstOPT=nEstOPT/sign(nEstOPT(3));

            nEstCubic=CubicNormalOPT(A,P1,P2,u1,v1,u2,v2,0,0);
            nEstCubic=nEstCubic/sign(nEstCubic(3));

            [nEstRapid,tmp1,tmp2]=RapidOpt(A,P1,P2,u1,v1,u2,v2,1,0,0);
            nEstRapid=nEstRapid/sign(nEstRapid(3));

            nEstHomography=NormalFromHomography(u1,v1,u2,v2,A,C1,C2,R2,t2,0);
            nEstHomography=nEstHomography/sign(nEstHomography(3));

%            "Est1"
%            nGT'*nEst1
%            nGT'*nEstSuper
%            nGT'*nEstOPT
%            nGT'*nEstCubic
%            nGT'*nEstRapid
%            nGT'*nEstHomography
%            "GT2"
%            norm(nGT)
%
%            pause

            currErr1=180*acos(min(nGT'*nEst1,1.0))/pi;
            currErrSuper=180*acos(min(nGT'*nEstSuper,1.0))/pi;
            currErrOPT=180*acos(min(nGT'*nEstOPT,1.0))/pi;
            currErrCubic=180*acos(min(nGT'*nEstCubic,1.0))/pi;
            currErrRapid=180*acos(min(nGT'*nEstRapid,1.0))/pi;
            currErrHomography=180*acos(min(nGT'*nEstHomography,1.0))/pi;

            errsEstFNE=[errsEstFNE;currErr1];
            errsEstFNESuper=[errsEstFNESuper;currErrSuper];
            errsOPT=[errsOPT;currErrOPT];
            errsCubic=[errsCubic;currErrCubic];
            errsRapid=[errsRapid;currErrRapid];
            errsHomography=[errsHomography;currErrHomography];

        end % for index
    end %for repeat

end
