close all

errors = real(abs(randn(1, 100000))) / 1e+8;

[N,edges] = histcounts(log10(errors), 15, 'Normalization', 'count');
edges = edges(2:end) - (edges(2)-edges(1))/2;

n = 100;
y1 = linspace(min(edges),max(edges), n);
data1 = interp1(edges, N, y1, 'pchip');

separator_color = [0.6 0.6 0.6]
separator_line_width = 2.0;
line_width = 3.0;

h = figure;
grid on;
set(h,'Units','Inches');
pos = get(h,'Position');
set(h,'PaperPositionMode','Auto','PaperUnits','Inches','PaperSize',[pos(3), pos(4)])

% Data
line('XData', y1, 'YData', data1, 'Color', [1 0 0], 'LineWidth', line_width, 'MarkerSize', 10)
set(gca,'fontsize', 13)

xlim([-14, 0])

xlabel('log_{10} avg. error', 'FontSize', 16, 'FontWeight', 'bold'); 
ylabel('Frequency', 'FontSize', 16, 'FontWeight', 'bold');

%lgd = legend({' 2SIFT', ' 4PT', ' 3ORI'},'FontSize', 14, 'Location', 'northeast')

print('stability_histogram','-dpdf','-r0') 