close all

%data=load("allNoiselessErrors.mat","-ascii");
data=load("allErrStability.mat","-ascii");

methods={'FNE_{ }','FNE_{SUPER}','OPT_{QUARTIC}','OPT_{CUBIC}','OPT_{LINEAR}','RAPOSO_{ }'}

%errors = real(abs(randn(1, 100000))) / 1e+8;

n=100;

h = figure;
grid on;
set(h,'Units','Inches');
pos = get(h,'Position');
pos(3)=150;
pos(4)=150;

set(h,'PaperUnits','Inches','PaperSize',[pos(3), pos(4)])

xlim([-17, -3]);

xlabel('log_{10} avg. error', 'FontSize', 16, 'FontWeight', 'bold'); 
ylabel('Frequency', 'FontSize', 16, 'FontWeight', 'bold');



hold on;


colors=[1.0,0,0;0,1.0,0;0,0,1.0;1,1,0;1,0,1;0,1,1];
colors=[1.0,0,0;0.7,0,0;0.5,0.5,0.0;0,1,1;0,0.7,1;0,1,1];

colors=[[39 115 191];[209 81 4];[124 172 34];[122 47 144];[231 176 0];[97 191 240]]/255;


for idx=1:6

    errors=data(:,idx);

    [N,edges] = histcounts(log10(errors), 100, 'Normalization', 'count');
    edges = edges(2:end) - (edges(2)-edges(1))/2;

    y1 = linspace(min(edges),max(edges), n);
    data1 = interp1(edges, N, y1, 'pchip');

    
    separator_color = [0.6 0.6 0.6]
    separator_line_width = 2.0;
    line_width = 3.0;


    % Data
    line('XData', y1, 'YData', data1, 'Color', colors(idx,:), 'LineWidth', line_width, 'MarkerSize', 10)
    set(gca,'fontsize', 13)

end
%lgd = legend({' 2SIFT', ' 4PT', ' 3ORI'},'FontSize', 14, 'Location', 'northeast')
lgd=legend(gca, methods, 'Location', 'northoutside');
lgd.Orientation='horizontal';
lgd.FontSize=13;
lgd.LineWidth=3;
lgd.NumColumns=6;




%exportgraphics(lgd,'legend.pdf');

print('stability_histogram2','-dpdf','-r0') 