REPEATNUM=100;

NOISE_AFF=0.0:0.00025:0.0025

meanEstFNE=[];
meanEstFNESuper=[];
meanOPT=[];
meanCubic=[];
meanRapid=[];
meanHomography=[];

medianEstFNE=[];
medianEstFNESuper=[];
medianOPT=[];
medianCubic=[];
medianRapid=[];
medianHomography=[];


for noiseLevel=NOISE_AFF

    errsEstFNE=0.0;
    errsEstFNESuper=0.0;
    errsOPT=0.0;
    errsCubic=0.0;
    errsRapid=0.0;
    errsHomography=0.0;

    [errsEstFNE,errsEstFNESuper,errsOPT,errsCubic,errsRapid,errsHomography]=TestSystem(0.0,noiseLevel,REPEATNUM)

%    noiseLevel
%    pause


    "---------- Median --------------"

%    "FNE"
    medianEstFNE=[medianEstFNE;median(errsEstFNE)]

%    "FNE Super"
    medianEstFNESuper=[medianEstFNESuper;median(errsEstFNESuper)]

%    "OPT"
    medianOPT=[medianOPT;median(errsOPT)]

%    "Cubic"
    medianCubic=[medianCubic;median(errsCubic)]

%    "Rapid"
    medianRapid=[medianRapid;median(errsRapid)]

%    "Homography"
    medianHomography=[medianHomography;median(errsHomography)]


    "----------- Mean ---------------"

%    "FNE"
    meanEstFNE=[meanEstFNE;mean(errsEstFNE)]

%    "FNE Super"
    meanEstFNESuper=[meanEstFNESuper;mean(errsEstFNESuper)]

%    "OPT"
    meanOPT=[meanOPT;mean(errsOPT)]

%    "Cubic"
    meanCubic=[meanCubic;mean(errsCubic)]

%    "Rapid"
    meanRapid=[meanRapid;mean(errsRapid)]

%    "Homography"
    meanHomography=[meanHomography;mean(errsHomography)]

endfor




    medianErrors=[NOISE_AFF',medianEstFNE,medianEstFNESuper,medianOPT,medianCubic,medianRapid,medianHomography];

    meanErrors=[NOISE_AFF',meanEstFNE,meanEstFNESuper,meanOPT,meanCubic,meanRapid,meanHomography];

    save("medianAffErrors.mat","-ascii","medianErrors")
    save("meanAffErrors.mat","-ascii","meanErrors")
