
# Code Repository for Paper - Enpowering Your Pansharpening Models with Generalizability: Unified Distribution is All You Need

This repository contains the complete code for our submitted review paper *Enpowering Your Pansharpening Models with Generalizability: Unified Distribution is All You Need*, including implementations for UniPAN training and testing on all 12 models (GPPNN, PanNet, PNN, FusionNet, FeINFN, UAPN, SFIIN, PreMix, MSDCNN, MSDDN, LAGConv, MDCUN).


## Environment Setup  
We provide an `env.yaml` file containing the complete conda environment configuration. To create the environment:  

1. Create conda environment from YAML file:  
```bash
conda env create -f env.yaml
```  

2. Activate the environment:  
```bash
conda activate unipan  # Use your environment name if different
```  


## Dataset Preparation
We use the public **NBU_PansharpRSData** dataset. Follow these steps to prepare the data:
1. Download and unzip the dataset
2. Modify dataset paths in the corresponding network file under `examples/` directory. For example, in `examples/{MODEL_NAME}.py`, update the `sensor2dir` dictionary:
```python
sensor2dir = {
    'wv2': '{YOUR_DATA_DIR}/5 WorldView-2',
    'gf1': '{YOUR_DATA_DIR}/3 Gaofen-1',
    'ik': '{YOUR_DATA_DIR}/1 IKONOS',
    'wv3': '{YOUR_DATA_DIR}/6 WorldView-3',
    'wv4': '{YOUR_DATA_DIR}/4 WorldView-4',
    'qb': '{YOUR_DATA_DIR}/2 QuickBird',
}
```
Replace the paths with your actual dataset locations.

## Training & Testing
### Basic Usage
1. Refer to parameter settings in the network files under `examples/`
2. Example command for training FeINFN with UniPAN on IKONOS and testing on multiple sensors:
```bash
python examples/FeINFN.py \
    --out_dist uniform \
    --train_sensor ik \
    --test_sensors wv2,gf1,wv3,wv4,qb
```

### Key Parameters
- `--out_dist`: Target distribution type (`uniform`/[others])
- `--train_sensor`: Training sensor name (e.g., `ik`)
- `--test_sensors`: Comma-separated list of test sensors

## Outputs
- Training logs and model weights are saved in `logs_uni/` directory
- Results are organized by experiment configuration
