#pragma once
// CAUTION: this file is auto-generated. DO NOT MODIFY!

#include <cstdint>

namespace babel::x64
{

enum class mnemonic : uint16_t
{
    _invalid,

    adc,
    add,
    addpd,
    addps,
    addsd,
    addss,
    addsubpd,
    addsubps,
    and_,
    andnpd,
    andnps,
    andpd,
    andps,
    blendpd,
    blendps,
    bsf,
    bsr,
    bswap,
    bt,
    btc,
    btr,
    bts,
    call,
    cbw,
    clc,
    cld,
    cli,
    cmc,
    cmovb,
    cmovbe,
    cmovl,
    cmovle,
    cmovnb,
    cmovnbe,
    cmovnl,
    cmovnle,
    cmovno,
    cmovnp,
    cmovns,
    cmovnz,
    cmovo,
    cmovp,
    cmovs,
    cmovz,
    cmp,
    cmppd,
    cmpps,
    cmps,
    cmpsd,
    cmpss,
    cmpxchg,
    cmpxchg8b,
    comisd,
    comiss,
    cpuid,
    cvtdq2pd,
    cvtdq2ps,
    cvtpd2dq,
    cvtpd2pi,
    cvtpd2ps,
    cvtpi2pd,
    cvtpi2ps,
    cvtps2dq,
    cvtps2pd,
    cvtps2pi,
    cvtsd2si,
    cvtsd2ss,
    cvtsi2sd,
    cvtsi2ss,
    cvtss2sd,
    cvtss2si,
    cvttpd2dq,
    cvttpd2pi,
    cvttps2dq,
    cvttps2pi,
    cvttsd2si,
    cvttss2si,
    cwd,
    dec,
    div,
    divpd,
    divps,
    divsd,
    divss,
    dppd,
    dpps,
    enter,
    extractps,
    fndisi,
    fneni,
    fnsetpm,
    fxrstor,
    fxsave,
    getsec,
    haddpd,
    haddps,
    hint_nop,
    hsubpd,
    hsubps,
    idiv,
    imul,
    in,
    inc,
    ins,
    insertps,
    int_,
    int1,
    into,
    iret,
    ja,
    jae,
    jb,
    jbe,
    je,
    jecxz,
    jg,
    jge,
    jl,
    jle,
    jmp,
    jmpe,
    jne,
    jno,
    jns,
    jo,
    jpe,
    jpo,
    js,
    lahf,
    lddqu,
    lea,
    leave,
    lfs,
    lgs,
    lods,
    loop,
    loopnz,
    loopz,
    lss,
    maskmovdqu,
    maskmovq,
    maxpd,
    maxps,
    maxsd,
    maxss,
    minpd,
    minps,
    minsd,
    minss,
    mov,
    movapd,
    movaps,
    movd,
    movddup,
    movdq2q,
    movdqa,
    movdqu,
    movhpd,
    movhps,
    movlpd,
    movlps,
    movmskpd,
    movmskps,
    movntdq,
    movnti,
    movntpd,
    movntps,
    movntq,
    movq,
    movq2dq,
    movs,
    movsd,
    movshdup,
    movsldup,
    movss,
    movsx,
    movsxd,
    movupd,
    movups,
    movzx,
    mpsadbw,
    mul,
    mulpd,
    mulps,
    mulsd,
    mulss,
    neg,
    nop,
    not_,
    or_,
    orpd,
    orps,
    out,
    outs,
    packssdw,
    packsswb,
    packuswb,
    paddb,
    paddd,
    paddq,
    paddsb,
    paddsw,
    paddusb,
    paddusw,
    paddw,
    palignr,
    pand,
    pandn,
    pause,
    pavgb,
    pavgw,
    pblendw,
    pcmpeqb,
    pcmpeqd,
    pcmpeqw,
    pcmpestri,
    pcmpestrm,
    pcmpgtb,
    pcmpgtd,
    pcmpgtw,
    pcmpistri,
    pcmpistrm,
    pextrb,
    pextrd,
    pextrw,
    pinsrb,
    pinsrd,
    pinsrw,
    pmaddwd,
    pmaxsw,
    pmaxub,
    pminsw,
    pminub,
    pmovmskb,
    pmulhuw,
    pmulhw,
    pmullw,
    pmuludq,
    pop,
    popcnt,
    popf,
    por,
    prefetchnta,
    prefetcht0,
    prefetcht1,
    prefetcht2,
    psadbw,
    pshufd,
    pshufhw,
    pshuflw,
    pshufw,
    pslld,
    pslldq,
    psllq,
    psllw,
    psrad,
    psraw,
    psrld,
    psrldq,
    psrlq,
    psrlw,
    psubb,
    psubd,
    psubq,
    psubsb,
    psubsw,
    psubusb,
    psubusw,
    psubw,
    punpckhbw,
    punpckhdq,
    punpckhqdq,
    punpckhwd,
    punpcklbw,
    punpckldq,
    punpcklqdq,
    punpcklwd,
    push,
    pushf,
    pxor,
    rcl,
    rcpps,
    rcpss,
    rcr,
    rdpmc,
    rdtsc,
    repnz,
    repz,
    retf,
    retn,
    rol,
    ror,
    roundpd,
    roundps,
    roundsd,
    roundss,
    rsqrtps,
    rsqrtss,
    sahf,
    sal,
    sar,
    sbb,
    scas,
    setb,
    setbe,
    setl,
    setle,
    setnb,
    setnbe,
    setnl,
    setnle,
    setno,
    setnp,
    setns,
    setnz,
    seto,
    setp,
    sets,
    setz,
    shld,
    shr,
    shrd,
    shufpd,
    shufps,
    sqrtpd,
    sqrtps,
    sqrtsd,
    sqrtss,
    stc,
    std,
    sti,
    stos,
    sub,
    subpd,
    subps,
    subsd,
    subss,
    syscall,
    sysenter,
    test,
    ucomisd,
    ucomiss,
    ud,
    ud2,
    unpckhpd,
    unpckhps,
    unpcklpd,
    unpcklps,
    xadd,
    xchg,
    xlat,
    xor_,
    xorpd,
    xorps,
    xsave
};
char const* to_string(mnemonic m);

namespace detail
{
extern uint16_t const decode_table[789];

static constexpr mnemonic entry_mnemonic(uint16_t entry) { return mnemonic(entry & 0b11'1111'1111); }
static constexpr bool entry_has_modrm(uint16_t entry) { return (entry & (1 << 10)) != 0; }
static constexpr bool entry_phase2_add_secondary(uint16_t entry) { return (entry & (1 << 11)) != 0; }
static constexpr bool entry_is_phase2(uint16_t entry) { return (entry & (1 << 15)) != 0; }
static constexpr uint8_t entry_get_immsize(uint16_t entry) { return entry >> 11; }
static constexpr int entry_phase2_get_offset(mnemonic m) { return int(m) + (512 - 136); }
}

} // babel::x64

