# This file contains basic defines and settings that are not provided by cmake out-of-the-box


# Setup important variables
#  - Operating System : GLOW_LINUX GLOW_MAC GLOW_WINDOWS  (also: GLOW_${OPERATING_SYSTEM})
#  - Compiler         : GLOW_GCC GLOW_CLANG GLOW_MSVC     (also: GLOW_${COMPILER})

SET(LINUX   ${UNIX})
SET(WINDOWS ${MSVC})
SET(MAC     ${APPLE})
IF(CMAKE_CXX_COMPILER_ID MATCHES "Clang")
    SET(CLANG ON)
    SET(COMPILER CLANG)
    SET(GCC OFF)
ELSE()
    IF(CMAKE_CXX_COMPILER MATCHES ".*[cg]\\+\\+")
        SET(GCC ON)
        SET(COMPILER GCC)
    ELSE()
        SET(GCC OFF)
    ENDIF()
    SET(CLANG OFF)
ENDIF()
IF(${MSVC})
    SET(COMPILER MSVC)
ENDIF()
IF(${WINDOWS})
    SET(OPERATING_SYSTEM WINDOWS)
ENDIF()
IF(${LINUX})
    SET(OPERATING_SYSTEM LINUX)
ENDIF()
IF(${MAC})
    SET(OPERATING_SYSTEM MAC)
ENDIF()
