#pragma once

#include <typed-geometry/detail/macros.hh>
#include <typed-geometry/functions/basic/scalar_math.hh>
#include <typed-geometry/types/color.hh>
#include <typed-geometry/types/comp.hh>
#include <typed-geometry/types/dir.hh>
#include <typed-geometry/types/pos.hh>
#include <typed-geometry/types/quat.hh>
#include <typed-geometry/types/size.hh>
#include <typed-geometry/types/vec.hh>

// Component-wise vectorized versions of scalar math

// TODO: make more generic with only one template, not repeat pos, size, vec, comp, color, ...

namespace tg
{
// abs
TG_IMPL_DEFINE_COMPWISE_FUNC_UNARY(pos, abs);
TG_IMPL_DEFINE_COMPWISE_FUNC_UNARY(vec, abs);
TG_IMPL_DEFINE_COMPWISE_FUNC_UNARY(dir, abs);
TG_IMPL_DEFINE_COMPWISE_FUNC_UNARY(size, abs);
TG_IMPL_DEFINE_COMPWISE_FUNC_UNARY(comp, abs);

// min
TG_IMPL_DEFINE_COMPWISE_FUNC_BINARY(pos, min);
TG_IMPL_DEFINE_COMPWISE_FUNC_BINARY(vec, min);
TG_IMPL_DEFINE_COMPWISE_FUNC_BINARY(size, min);
TG_IMPL_DEFINE_COMPWISE_FUNC_BINARY(comp, min);

// max
TG_IMPL_DEFINE_COMPWISE_FUNC_BINARY(pos, max);
TG_IMPL_DEFINE_COMPWISE_FUNC_BINARY(vec, max);
TG_IMPL_DEFINE_COMPWISE_FUNC_BINARY(size, max);
TG_IMPL_DEFINE_COMPWISE_FUNC_BINARY(comp, max);

// sin
TG_IMPL_DEFINE_COMPWISE_FUNC_UNARY(pos, sin);
TG_IMPL_DEFINE_COMPWISE_FUNC_UNARY(vec, sin);
TG_IMPL_DEFINE_COMPWISE_FUNC_UNARY(size, sin);
TG_IMPL_DEFINE_COMPWISE_FUNC_UNARY(comp, sin);

// cos
TG_IMPL_DEFINE_COMPWISE_FUNC_UNARY(pos, cos);
TG_IMPL_DEFINE_COMPWISE_FUNC_UNARY(vec, cos);
TG_IMPL_DEFINE_COMPWISE_FUNC_UNARY(size, cos);
TG_IMPL_DEFINE_COMPWISE_FUNC_UNARY(comp, cos);

// sqrt
TG_IMPL_DEFINE_COMPWISE_FUNC_UNARY(pos, sqrt);
TG_IMPL_DEFINE_COMPWISE_FUNC_UNARY(vec, sqrt);
TG_IMPL_DEFINE_COMPWISE_FUNC_UNARY(size, sqrt);
TG_IMPL_DEFINE_COMPWISE_FUNC_UNARY(comp, sqrt);

// cbrt
TG_IMPL_DEFINE_COMPWISE_FUNC_UNARY(pos, cbrt);
TG_IMPL_DEFINE_COMPWISE_FUNC_UNARY(vec, cbrt);
TG_IMPL_DEFINE_COMPWISE_FUNC_UNARY(size, cbrt);
TG_IMPL_DEFINE_COMPWISE_FUNC_UNARY(comp, cbrt);

// pow
TG_IMPL_DEFINE_COMPWISE_FUNC_BINARY(pos, pow);
TG_IMPL_DEFINE_COMPWISE_FUNC_BINARY(vec, pow);
TG_IMPL_DEFINE_COMPWISE_FUNC_BINARY(size, pow);
TG_IMPL_DEFINE_COMPWISE_FUNC_BINARY(comp, pow);

// pow2
TG_IMPL_DEFINE_COMPWISE_FUNC_UNARY(pos, pow2);
TG_IMPL_DEFINE_COMPWISE_FUNC_UNARY(vec, pow2);
TG_IMPL_DEFINE_COMPWISE_FUNC_UNARY(size, pow2);
TG_IMPL_DEFINE_COMPWISE_FUNC_UNARY(comp, pow2);

// pow3
TG_IMPL_DEFINE_COMPWISE_FUNC_UNARY(pos, pow3);
TG_IMPL_DEFINE_COMPWISE_FUNC_UNARY(vec, pow3);
TG_IMPL_DEFINE_COMPWISE_FUNC_UNARY(size, pow3);
TG_IMPL_DEFINE_COMPWISE_FUNC_UNARY(comp, pow3);

// pow4
TG_IMPL_DEFINE_COMPWISE_FUNC_UNARY(pos, pow4);
TG_IMPL_DEFINE_COMPWISE_FUNC_UNARY(vec, pow4);
TG_IMPL_DEFINE_COMPWISE_FUNC_UNARY(size, pow4);
TG_IMPL_DEFINE_COMPWISE_FUNC_UNARY(comp, pow4);

// pow5
TG_IMPL_DEFINE_COMPWISE_FUNC_UNARY(pos, pow5);
TG_IMPL_DEFINE_COMPWISE_FUNC_UNARY(vec, pow5);
TG_IMPL_DEFINE_COMPWISE_FUNC_UNARY(size, pow5);
TG_IMPL_DEFINE_COMPWISE_FUNC_UNARY(comp, pow5);

// round
TG_IMPL_DEFINE_COMPWISE_FUNC_UNARY(pos, round);
TG_IMPL_DEFINE_COMPWISE_FUNC_UNARY(vec, round);
TG_IMPL_DEFINE_COMPWISE_FUNC_UNARY(size, round);
TG_IMPL_DEFINE_COMPWISE_FUNC_UNARY(comp, round);

// iround
TG_IMPL_DEFINE_COMPWISE_FUNC_UNARY(pos, iround);
TG_IMPL_DEFINE_COMPWISE_FUNC_UNARY(vec, iround);
TG_IMPL_DEFINE_COMPWISE_FUNC_UNARY(size, iround);
TG_IMPL_DEFINE_COMPWISE_FUNC_UNARY(comp, iround);

// floor
TG_IMPL_DEFINE_COMPWISE_FUNC_UNARY(pos, floor);
TG_IMPL_DEFINE_COMPWISE_FUNC_UNARY(vec, floor);
TG_IMPL_DEFINE_COMPWISE_FUNC_UNARY(size, floor);
TG_IMPL_DEFINE_COMPWISE_FUNC_UNARY(comp, floor);

// ifloor
TG_IMPL_DEFINE_COMPWISE_FUNC_UNARY(pos, ifloor);
TG_IMPL_DEFINE_COMPWISE_FUNC_UNARY(vec, ifloor);
TG_IMPL_DEFINE_COMPWISE_FUNC_UNARY(size, ifloor);
TG_IMPL_DEFINE_COMPWISE_FUNC_UNARY(comp, ifloor);

// ceil
TG_IMPL_DEFINE_COMPWISE_FUNC_UNARY(pos, ceil);
TG_IMPL_DEFINE_COMPWISE_FUNC_UNARY(vec, ceil);
TG_IMPL_DEFINE_COMPWISE_FUNC_UNARY(size, ceil);
TG_IMPL_DEFINE_COMPWISE_FUNC_UNARY(comp, ceil);

// iceil
TG_IMPL_DEFINE_COMPWISE_FUNC_UNARY(pos, iceil);
TG_IMPL_DEFINE_COMPWISE_FUNC_UNARY(vec, iceil);
TG_IMPL_DEFINE_COMPWISE_FUNC_UNARY(size, iceil);
TG_IMPL_DEFINE_COMPWISE_FUNC_UNARY(comp, iceil);

// fract
TG_IMPL_DEFINE_COMPWISE_FUNC_UNARY(pos, fract);
TG_IMPL_DEFINE_COMPWISE_FUNC_UNARY(vec, fract);
TG_IMPL_DEFINE_COMPWISE_FUNC_UNARY(size, fract);
TG_IMPL_DEFINE_COMPWISE_FUNC_UNARY(comp, fract);

// sign
TG_IMPL_DEFINE_COMPWISE_FUNC_UNARY(pos, sign);
TG_IMPL_DEFINE_COMPWISE_FUNC_UNARY(vec, sign);
TG_IMPL_DEFINE_COMPWISE_FUNC_UNARY(size, sign);
TG_IMPL_DEFINE_COMPWISE_FUNC_UNARY(comp, sign);

// clamp
TG_IMPL_DEFINE_COMPWISE_FUNC_TERNARY(pos, clamp);
TG_IMPL_DEFINE_COMPWISE_FUNC_TERNARY(vec, clamp);
TG_IMPL_DEFINE_COMPWISE_FUNC_TERNARY(size, clamp);
TG_IMPL_DEFINE_COMPWISE_FUNC_TERNARY(comp, clamp);

// saturate
TG_IMPL_DEFINE_COMPWISE_FUNC_UNARY(pos, saturate);
TG_IMPL_DEFINE_COMPWISE_FUNC_UNARY(vec, saturate);
TG_IMPL_DEFINE_COMPWISE_FUNC_UNARY(size, saturate);
TG_IMPL_DEFINE_COMPWISE_FUNC_UNARY(comp, saturate);

// tests
TG_IMPL_DEFINE_COMPWISE_UNARY_TO_COMP(pos, is_nan);
TG_IMPL_DEFINE_COMPWISE_UNARY_TO_COMP(pos, is_inf);
TG_IMPL_DEFINE_COMPWISE_UNARY_TO_COMP(pos, is_zero);
TG_IMPL_DEFINE_COMPWISE_UNARY_TO_COMP(pos, is_finite);

TG_IMPL_DEFINE_COMPWISE_UNARY_TO_COMP(vec, is_nan);
TG_IMPL_DEFINE_COMPWISE_UNARY_TO_COMP(vec, is_inf);
TG_IMPL_DEFINE_COMPWISE_UNARY_TO_COMP(vec, is_zero);
TG_IMPL_DEFINE_COMPWISE_UNARY_TO_COMP(vec, is_finite);

TG_IMPL_DEFINE_COMPWISE_UNARY_TO_COMP(dir, is_nan);
TG_IMPL_DEFINE_COMPWISE_UNARY_TO_COMP(dir, is_inf);
TG_IMPL_DEFINE_COMPWISE_UNARY_TO_COMP(dir, is_zero);
TG_IMPL_DEFINE_COMPWISE_UNARY_TO_COMP(dir, is_finite);

TG_IMPL_DEFINE_COMPWISE_UNARY_TO_COMP(size, is_nan);
TG_IMPL_DEFINE_COMPWISE_UNARY_TO_COMP(size, is_inf);
TG_IMPL_DEFINE_COMPWISE_UNARY_TO_COMP(size, is_zero);
TG_IMPL_DEFINE_COMPWISE_UNARY_TO_COMP(size, is_finite);

TG_IMPL_DEFINE_COMPWISE_UNARY_TO_COMP(comp, is_nan);
TG_IMPL_DEFINE_COMPWISE_UNARY_TO_COMP(comp, is_inf);
TG_IMPL_DEFINE_COMPWISE_UNARY_TO_COMP(comp, is_zero);
TG_IMPL_DEFINE_COMPWISE_UNARY_TO_COMP(comp, is_finite);
} // namespace tg
