# FastPoint
This is an implementation of our paper "FastPoint: Accelerating 3D Point Cloud Model Inference via Sample Point Distance Prediction".

## Install
```
source install.sh
```
Note:

   We recommend using CUDA 11.x; check your CUDA version by: `nvcc --version` before using the bash file;


## Prepare Dataset

### ModelNet40
ModelNet40 dataset is downloaded automatically.

### S3DIS
```
mkdir -p data/S3DIS/
cd data/S3DIS
gdown https://drive.google.com/uc?id=1MX3ZCnwqyRztG1vFRiHkKTz68ZJeHS4Y
tar -xvf s3disfull.tar
```

### ScanNet
```
cd data
gdown https://drive.google.com/uc?id=1uWlRPLXocqVbJxPvA2vcdQINaZzXf1z_
tar -xvf ScanNet.tar
```

## Testing Inference Speed (val mode)
### S3DIS, ScanNet, SemanticKITTI (PointVector, PointMetaBase)
```
# PointVector is implemented in PointNeXt directory. Run the command in PointNeXt directory for PointVector models.

# Run baseline
CUDA_VISIBLE_DEVICES=0 bash script/main_segmentation.sh cfgs/[s3dis, scannet, semantickitti]/[pointvector-l, pointmetabase-l].yaml wandb.use_wandb=False mode=val --pretrained_path [path]

# Run with FastPoint
CUDA_VISIBLE_DEVICES=0 bash script/main_segmentation.sh cfgs/[s3dis, scannet, semantickitti]/[pointvector-l-fused, pointmetabase-l-fused].yaml wandb.use_wandb=False mode=val --pretrained_path [path]

# Run with FastPoint+QuickFPS
CUDA_VISIBLE_DEVICES=0 bash script/main_segmentation.sh cfgs/[s3dis, scannet, semantickitti]/[pointvector-l-all, pointmetabase-l-all].yaml wandb.use_wandb=False mode=val --pretrained_path [path]
```

## Testing Model Accuracy (test mode)
### S3DIS, ScanNet, SemanticKITTI (PointVector, PointMetaBase)
```
# PointVector is implemented in PointNeXt directory. Run the command in PointNeXt directory for PointVector models.

# Run baseline
CUDA_VISIBLE_DEVICES=0 bash script/main_segmentation.sh cfgs/[s3dis, scannet, semantickitti]/[pointvector-l, pointmetabase-l].yaml wandb.use_wandb=False mode=test --pretrained_path [path]

# Run with FastPoint
CUDA_VISIBLE_DEVICES=0 bash script/main_segmentation.sh cfgs/[s3dis, scannet, semantickitti]/[pointvector-l-fused, pointmetabase-l-fused].yaml wandb.use_wandb=False mode=test --pretrained_path [path]

# Run with FastPoint+QuickFPS
CUDA_VISIBLE_DEVICES=0 bash script/main_segmentation.sh cfgs/[s3dis, scannet, semantickitti]/[pointvector-l-all, pointmetabase-l-all].yaml wandb.use_wandb=False mode=test --pretrained_path [path]
```

## Acknowledgment
This repository is built on reusing codes of [Frugal\_PN\_Training](https://github.com/SNU-ARC/Frugal_PN_Training.git), [PointMetaBase](https://github.com/linhaojia13/PointMetaBase), [OpenPoints](https://github.com/guochengqian/openpoints) and [PointNeXt](https://github.com/guochengqian/PointNeXt).
