# Code for From Reusing to Forecasting: Accelerating Diffusion Models with Taylor Seers

ICCV 4418 Anonymous Submission

## Prepare Environment

Just follow the instruction of the Official Version of FLUX, HunyuanVideo and DiT.

## Taylor-DiT

### Single Image

```bash
python sample.py --num-sampling-steps 50 --ddim-sample --interval 4 --max-order 2
```

### Sample with DDP

```bash
torchrun --nnodes=1 --nproc_per_node=6 sample_ddp.py --model DiT-XL/2 --per-proc-batch-size 150 --image-size 256 --cfg-scale 1.5 --num-sampling-steps 50 --ddim-sample --interval 4 --max-order 2
```

## Taylor-FLUX

```bash
python src/sample.py   --prompt_file /path/to/your/prompts.txt  --width 1024  --height 1024 --model_name flux-dev  --num_steps 50 --add_sampling_metadata  --output_dir /path/to/save/images
```

## Taylor-HunyuanVideo

### Single Video

```bash
python3 sample_video.py \
    --seed 42 \
    --video-size 480 640 \
    --video-length 65 \
    --infer-steps 50 \
    --prompt "A cat walks on the grass, realistic style." \
    --flow-reverse \
    --use-cpu-offload \
    --save-path /path/to/save/video
```

### Sample with VBench

```bash
./eval/sample_vbench.sh ./eval/ 1 42 5 </path/to/save/videos> </path/to/log/files>
```